
function [end_Vm, V_avg] = cum_spikes_ahp_plot(a_t, a_prof, period, title_str, plotit, verbose, filename)
    if nargin < 7
        filename = '';
    end
    if nargin < 6
        verbose = 0;
    end
    if nargin < 5
        plotit = 0;
    end

    t = a_t.props.t;
    V = a_t.data;
    x=t(a_prof.timeidx)';

    if plotit
        f = figure;
        hold on;
    end

    tolerance = 0.1;
    V_avg = [];
    max_Vm_end = -120;
    min_Vm = 0;
    max_t = 0;
    cmap = colormap(gray);
    end_Vm = [];
    for i=1:length(x)
        s_idx=min(find(t==x(i)));
        period_end = min(find(abs(t-(t(s_idx)+period/2))<tolerance));

        t_end = t(period_end)-t(s_idx);
        if t_end > max_t
            max_t = t_end;
        end

        if plotit
            cmap_idx = floor(rand*63);
            plot(t(s_idx:period_end)-t(s_idx),V(s_idx:period_end),'Color',cmap(cmap_idx+1,:,:));
disp(sprintf('t %g V %g min_t %g end_t %g min_V %g end_V %g\n', length(t(s_idx:period_end)-t(s_idx)), length(V(s_idx:period_end)), t(s_idx)-t(s_idx), t(period_end)-t(s_idx), V(s_idx), V(period_end)));
        end
        end_Vm = [end_Vm V(period_end)];

        % Find max Vm in second half and min Vm over entire period.
        second_half_start = min(find(abs(t-(t(s_idx)+period/4))<tolerance));
        cur_max_Vm_end = max(V(second_half_start:period_end));
        if cur_max_Vm_end > max_Vm_end
            max_Vm_end = cur_max_Vm_end;
        end
        cur_min_Vm = min(V(s_idx:period_end));
        if cur_min_Vm < min_Vm
            min_Vm = cur_min_Vm;
        end
    end

    % Figure out where to crop. Take max of last 1/2 of traces, and cut off y of
    % first half just a bit above that. Also cut off just a bit below min of y.
    % For x-axis, make sure we don't go beyond the max of traces (somehow MATLAB 
    % doesn't do this even if "xlim auto" or "axis 'auto x'" are specified.
    ylim([min_Vm-1 max_Vm_end+1]);
    xlim([0 max_t]);
    
    set(gca,'FontSize',16);
    title(title_str);
    xlabel('Post-spike time (ms)')
    ylabel('V_m (mV)');
    set(gca,'box','off');
    f.PaperUnits = 'inches';
    f.PaperPosition = [0 0 6 5];


%{
    for i=1:length(y)
        start_time = y(i);
        cur_spikes = find(x < start_time+period & x > start_time);
        if cur_spikes

            period_window = find(t < start_time+period & t > start_time);
            if plotit
                plot(t(period_window)-y(i), V(period_window),'k');
            end

            % Figure out the relative time of spike height as index into the window of t we're considering.
            rel_spike_time = x(cur_spikes);
            spike_time_environs = find(abs(t(period_window)-rel_spike_time) < tolerance);
            spike_diff = spike_time_environs(round(length(spike_time_environs)/2)); % midpoint 
            t_spikes = [t_spikes t(period_window(spike_diff))-y(i)];
            if i>1 || (i==1 && x(cur_spikes)>y(1))
                x_chosen = [x_chosen cur_spikes];
            end
            if verbose
                disp(sprintf('*** window < %g+%g & > %g at y(%d)=%g WITH x(%d)=%g, spike_diff %g', start_time, period, start_time, i, y(i), cur_spikes, x(cur_spikes), spike_diff));
            end
        end
    end 

    if plotit
        c=x(x_chosen)*1e-3;
        colormap(jet(round(max(c))));

        circle_size=20;
        scatter(t_spikes, ones(length(t_spikes),1)+max(V), circle_size, c, 'filled');
        colorbar;

        xlim([0 period]);
%        set(gca,'XTick',[0 period/4 period/2 period*3/4 period]);
        set(gca,'FontSize',16);
        xlabel('Relative time in period (ms)');
        ylabel('V_m (mV)');
        title(title_str);
    end
%}

    if filename
        input('Press Enter to print.');
        disp(sprintf('PRINTING to file %s', filename));
        print(f, filename, '-dpng');
    end

end
