%{

    ranks is an array of ranks to process; ignore everything else. Facilitates splitting the work into 
    multiple MATLAB instances to save memory.

%}
function [avg_end_Vms] = cum_spikes_load_sets(topdir, ranks, props)
    if nargin < 3
        props = struct();
    end

    % 1 for up to 8Hz, 2 for 9Hz+
    if isfield(props,'mf_suffix')
        mf_suffix = props.mf_suffix;
    else
        mf_suffix = 1;
    end
    % desired mf; default 8Hz.
    if isfield(props,'mf')
        dmf=props.mf;
    else
        dmf=8;
    end
    % verbosity
    if isfield(props,'verbose')
        verbose=props.verbose;
    else
        verbose=0;
    end
    % plot each model set of end_Vms or not
    if isfield(props,'plotit')
        plotit=props.plotit;
    else
        plotit=0;
    end

    % type of models; need to adjust file format accordingly.
    model_dir_format_ctl = 'scen%d_mod_%d_sdm_%d_%d';
    rank_idx = 3;
    mf_subdir_idx = 4;
    model_mod_format_ctl = 'R3_somadend_rank%d_h_%g_excw_%g_inhw_%g_tstop_%d_modfreq_%g_modulation_%g_injclamp_%d.dat';
    modfreq_idx = 6;
    if isfield(props,'mod_type')
        mod_type=props.mod_type;
        if strcmp(mod_type,'blks')
            model_dir_format = 'scen%d_mod_blks_%d_sdm_%d_%d';
            model_mod_format = 'R3_somadend_rank%d_h_%g_Kdrs_%g_excw_%g_inhw_%g_tstop_%d_modfreq_%g_modulation_%g_injclamp_%d.dat';
            modfreq_idx = 7;
        elseif strcmp(mod_type,'blka')
            model_dir_format = 'scen%d_mod_blka_%d_sdm_%d_%d';
            model_mod_format = 'R3_somadend_rank%d_h_%g_Kdrs_%g_KA_%g_excw_%g_inhw_%g_tstop_%d_modfreq_%g_modulation_%g_injclamp_%d.dat';
            modfreq_idx = 8;
        else
            model_dir_format = model_dir_format_ctl;
            model_mod_format = model_mod_format_ctl;
        end
    else
        model_dir_format = model_dir_format_ctl;
        model_mod_format = model_mod_format_ctl;
    end

    avg_end_Vms = [];

    cd(topdir);
    dirpath = sprintf('%s*', topdir);
    dirs = dir(dirpath);
    tot_dirs = length(dirs);

    for i=1:tot_dirs
        current_model_dir = dirs(i).name;
        % skip . and ..
        if strcmp(current_model_dir, '.') || strcmp(current_model_dir, '..')
            continue;
        end
        disp(sprintf('*** Processing model dir %s', current_model_dir));

        % skip if nomod
        if ~isempty(strfind(current_model_dir, 'nomod')) % then 'nomod' is part of dir name
            disp(sprintf('    This is nomod; skipping...\n'));
            continue;
        end

        % Only enter desired rank and mf subdir; note rank while doing so
        A = sscanf(current_model_dir, model_dir_format);
        rank = A(rank_idx);               
        if ~ismember(rank, ranks)
            disp(sprintf('    We do not want rank %d; skipping...\n', rank));
            continue;
        end

        mf_subdir = A(mf_subdir_idx);
        if mf_subdir == mf_suffix
            disp(sprintf('    We have rank %d and desired mf suffix %s. Proceeding...\n', rank, mf_subdir));
        else
            disp(sprintf('    Not desired mf suffix %s (we want %s); skipping...\n', mf_subdir, mf_suffix));
            continue;
        end

        cd(current_model_dir);
        if ~exist('dev', 'file')
            disp(sprintf('    *** NO dev FILE; SKIPPING....\n'));
            cd('..');
            continue;
        end
        outfile_dir = './dev/shm/vsekulic/O-LM_runs/';
        cd(outfile_dir);

        outfiles = dir('*.dat');
        pwd
        for j=1:length(outfiles)
            model_name = outfiles(j).name;
            A = sscanf(model_name, model_mod_format);
            modfreq = A(modfreq_idx);
            if modfreq ~= dmf
                disp(sprintf('    We do not want modfreq %d; skipping...', modfreq));
                continue;
            end

            [a_t, a_prof, pxx, f, V] = phd_exc_psd(model_name);
            period = 1000/dmf; % 8Hz
            end_Vms = cum_spikes_ahp_plot(a_t, a_prof, period, sprintf('rank %d', rank), plotit, verbose, '');
            avg_end_Vm = mean(end_Vms);
            disp(sprintf('\n*** AVG end_Vm for rank %d is %g', rank, avg_end_Vm));
            avg_end_Vms = [avg_end_Vms avg_end_Vm];
        end
        cd('../../../../../');
        disp(sprintf('\n*** COMPLETED %s\n', current_model_dir));
        if verbose
            input('Press Enter to continue.');
        end
    end
    cd('..'); % go back to topdir
end
