
function [t_spikes] = cum_spikes_plot(a_t, a_prof, y, period, title_str, plotit, verbose, filename)
    if nargin < 8
        filename = '';
    end
    if nargin < 7
        verbose = 0;
    end
    if nargin < 6
        plotit = 0;
    end
    want_circles = 0;

    t = a_t.props.t;
    V = a_t.data;
    x=t(a_prof.timeidx)';

    if plotit
        f = figure;
        hold on;
    end

    t_spikes = [];
    tolerance = 0.01;
    x_chosen = [];
    for i=1:length(y)
        start_time = y(i);
        cur_spikes = find(x < start_time+period & x > start_time);
        if cur_spikes
        for j=1:length(cur_spikes)
            cur_spike = cur_spikes(j);

            period_window = find(t < start_time+period & t > start_time);
            if plotit
                plot(t(period_window)-y(i), V(period_window),'k');
            end

            % Figure out the relative time of spike height as index into the window of t we're considering.
            rel_spike_time = x(cur_spike);
            spike_time_environs = find(abs(t(period_window)-rel_spike_time) < tolerance);
            spike_diff = spike_time_environs(round(length(spike_time_environs)/2)); % midpoint 
            t_spikes = [t_spikes t(period_window(spike_diff))-y(i)];
            if i>1 || (i==1 && x(cur_spike)>y(1))
                x_chosen = [x_chosen cur_spike];
            end
            if verbose
                disp(sprintf('*** window < %g+%g & > %g at y(%d)=%g WITH x(%d)=%g, spike_diff %g', start_time, period, start_time, i, y(i), cur_spike, x(cur_spike), spike_diff));
            end
        end
        end
    end 

    if plotit
        c=x(x_chosen)*1e-3;
        colormap(jet(round(max(c))));

        if want_circles
            circle_size=20;
            scatter(t_spikes, ones(length(t_spikes),1)+max(V), circle_size, c, 'filled');
            colorbar;
        end

        f.PaperUnits = 'inches';
        f.PaperPosition = [0 0 6 5];

        xlim([0 period]);
%        set(gca,'XTick',[0 period/4 period/2 period*3/4 period]);
        set(gca,'FontSize',16);
%        xlabel('Relative time in period (ms)');
        xlabel('Post-stimulus time (ms)');
        ylabel('V_m (mV)');
        title(title_str);
    end

    if filename
        input('Press Enter to print.');
        disp(sprintf('PRINTING to file %s', filename));
        print(f, filename, '-dpng');
%        print(f, filename, '-dsvg');
    end
end
