
cd ~/research/project/MAT_files;
%fileloc = '';
%fileloc = '~/research/project/img/psl_annrep2016';
%fileloc = '~/Dropbox/research/project/img/eLife2016';
fileloc_DIR = '~/Dropbox/research/Vlad_grad PhD tmp/2016 eLife paper/figures/'
fileloc_rev_DIR = 'c:/Users/vsekulic/Dropbox/research/Vlad_grad PhD tmp/2016 eLife paper/figures_rev/'
fileloc_NUL = '';
fileloc = fileloc_DIR;

freq=8;
yt=[1e3/freq/2:1e3/freq:floor(t(length(t)))];
period = 1e3/freq;


%{ 

LOAD & ANALYZE ALL THE DATA

%}

load_syn_data;

% blh scen4

% blh scen5

% cAMP scen4
scen4_cAMP = load('scen4_cAMP_mo_0.4.mat');
scen4_cAMP2 = load('scen4_cAMP2_mo_0.4.mat');
scen4_cAMP_blh = load('scen4_cAMP_blh_mo_0.4.mat');
models4_cAMP = scen4_cAMP.models;
models4_cAMP2 = scen4_cAMP2.models;
models4_cAMP_blh = scen4_cAMP_blh.models;
hD0_ranks4_cAMP=scen4_cAMP.hD0_ranks;
hD1_ranks4_cAMP=scen4_cAMP.hD1_ranks;
hD0_ranks4_cAMP2=scen4_cAMP2.hD0_ranks;
hD1_ranks4_cAMP2=scen4_cAMP2.hD1_ranks;
hD0_ranks4_cAMP_blh=scen4_cAMP_blh.hD0_ranks;
hD1_ranks4_cAMP_blh=scen4_cAMP_blh.hD1_ranks;

% cAMP scen5
scen5_cAMP = load('scen5_cAMP_mo_0.4.mat');
scen5_cAMP2 = load('scen5_cAMP2_mo_0.4.mat');
scen5_cAMP_blh = load('scen5_cAMP_blh_mo_0.4.mat');
models5_cAMP = scen5_cAMP.models;
models5_cAMP2 = scen5_cAMP2.models;
models5_cAMP_blh = scen5_cAMP_blh.models;
hD0_ranks5_cAMP=scen5_cAMP.hD0_ranks;
hD0_ranks5_cAMP2=scen5_cAMP2.hD0_ranks;
hD1_ranks5_cAMP=scen5_cAMP.hD1_ranks;
hD1_ranks5_cAMP2=scen5_cAMP2.hD1_ranks;
hD0_ranks5_cAMP_blh=scen5_cAMP_blh.hD0_ranks;
hD1_ranks5_cAMP_blh=scen5_cAMP_blh.hD1_ranks;

% cAMP analysis
pr_struct4_cAMP = phd_exc_anal_pratio(models4_cAMP, models4_cAMP_blh, desired_mo, mf)
pr_struct4_cAMP2 = phd_exc_anal_pratio(models4_cAMP2, models4_cAMP_blh, desired_mo, mf)
pr_struct5_cAMP = phd_exc_anal_pratio(models5_cAMP, models5_cAMP_blh, desired_mo, mf)
pr_struct5_cAMP2 = phd_exc_anal_pratio(models5_cAMP2, models5_cAMP_blh, desired_mo, mf)
rotn_struct4_cAMP = phd_exc_anal_rotn(models4_cAMP, models4_cAMP_blh, 0.4, mf(~ismember(mf,[0.1 0.5])), 0, '');
rotn_struct4_cAMP2 = phd_exc_anal_rotn(models4_cAMP2, models4_cAMP_blh, 0.4, mf(~ismember(mf,[0.1 0.5])), 0, '');
rotn_struct5_cAMP = phd_exc_anal_rotn(models5_cAMP, models5_cAMP_blh, 0.4, mf(~ismember(mf,[0.1 0.5])), 0, '');
rotn_struct5_cAMP2 = phd_exc_anal_rotn(models5_cAMP2, models5_cAMP_blh, 0.4, mf(~ismember(mf,[0.1 0.5])), 0, '');
VS_struct4_cAMP = phd_exc_anal_VS(models4_cAMP, models4_cAMP_blh, 0.4, 0, fileloc)
VS_struct4_cAMP2 = phd_exc_anal_VS(models4_cAMP2, models4_cAMP_blh, 0.4, 0, fileloc)
VS_struct5_cAMP = phd_exc_anal_VS(models5_cAMP, models5_cAMP_blh, 0.4, 0, fileloc)
VS_struct5_cAMP2 = phd_exc_anal_VS(models5_cAMP2, models5_cAMP_blh, 0.4, 0, fileloc)
am_struct4_cAMP = phd_exc_anal_angmean(models4_cAMP, models4_cAMP_blh, 0.4, 0, fileloc);
am_struct4_cAMP2 = phd_exc_anal_angmean(models4_cAMP2, models4_cAMP_blh, 0.4, 0, fileloc);
am_struct5_cAMP = phd_exc_anal_angmean(models5_cAMP, models5_cAMP_blh, 0.4, 0, fileloc);
am_struct5_cAMP2 = phd_exc_anal_angmean(models5_cAMP2, models5_cAMP_blh, 0.4, 0, fileloc);

%
% NEW cAMP struct acquisition (old is above)
%

% hleak
models5_idx_hleak = [1:18 20:22 26:32];
[hD0_ranks, hD1_ranks] = phd_exc_load_models_to_ranks(models5(models5_idx_hleak));
[hD0_ranks_hleak, hD1_ranks_hleak] = phd_exc_load_models_to_ranks(models_hleak);
pr_struct_hleak = phd_exc_anal_pratio(models5(models5_idx_hleak), models_hleak, desired_mo, mf);
[cell1_ranks, cell2_ranks] = phd_exc_load_cells_to_ranks(models5(models5_idx_hleak));
[cell1_ranks_hleak, cell2_ranks_hleak] = phd_exc_load_cells_to_ranks(models_hleak);
rotn_struct_hleak = phd_exc_anal_rotn(models5(models5_idx_hleak), models_hleak, desired_mo, mf(~ismember(mf,[0.1 0.5])), 0, '');

% this might as well go here
hD1_idx = [1:3 5:13 15:16]; % idx 4 and 14 missing in ctl (respectively ranks 2050 and 913, both hD1

% blks scen5 scen5_blks = load('scen5_blks_mo_0.4.mat');
models5_blks = scen5_blks.models;
hD0_ranks5_blks=scen5_blks.hD0_ranks;
hD1_ranks5_blks=scen5_blks.hD1_ranks;

%
% blks analysis (note trick of ctl being regular scen5; "blh" is blks here.
%

% Get ranks for both blh and blks
blh_ranks = get_ranks_from_idx(models5_blh, 1:length(models5_blh));
blks_ranks = get_ranks_from_idx(models5_blks, 1:length(models5_blks));
blh_blks_ranks = intersect(blh_ranks, blks_ranks);
blh_blks_hD1_ranks = intersect(blh_blks_ranks, ranks_hD1);

models5_blh_blks = models_only_ranks(models5_blh,blh_blks_ranks);
models5_blks_blh = models_only_ranks(models5_blks,blh_blks_ranks);
pr_struct5_blks = phd_exc_anal_pratio(models5_blh_blks, models5_blks_blh, desired_mo, mf)
rotn_struct5_blks = phd_exc_anal_rotn(models5_blh_blks, models5_blks_blh, 0.4, mf(~ismember(mf,[0.1])), 0, '');
VS_struct5_blks = phd_exc_anal_VS(models5_blh_blks, models5_blks_blh, 0.4, 0, '')
am_struct5_blks = phd_exc_anal_angmean(models5_blh_blks, models5_blks_blh, 0.4, 0, '');

% blka scen5
scen5_blka = load('scen5_blka_mo_0.4.mat');
models5_blka = scen5_blka.models;
hD0_ranks5_blka=scen5_blka.hD0_ranks;
hD1_ranks5_blka=scen5_blka.hD1_ranks;

%
% blka analysis (note trick of ctl being regular scen5; "blh" is blka here.
%

% Get ranks for both blh and blka 
hD1_blka_idx = [2:10 12 14:16 18:25 27:30 32];
blka_ranks = get_ranks_from_idx(models5_blka, hD1_blka_idx);
blh_blka_ranks = intersect(blh_ranks, blka_ranks);

models5_blh_blka = models_only_ranks(models5_blh,blh_blka_ranks);
models5_blka_blh = models_only_ranks(models5_blka,blh_blka_ranks);
pr_struct5_blka = phd_exc_anal_pratio(models5_blh_blka, models5_blka_blh, desired_mo, mf);
rotn_struct5_blka = phd_exc_anal_rotn(models5_blh_blka, models5_blka_blh, 0.4, mf(~ismember(mf,[0.1])), 0, '');
VS_struct5_blka = phd_exc_anal_VS(models5_blh_blka, models5_blka_blh, 0.4, 0, '')
am_struct5_blka = phd_exc_anal_angmean(models5_blh_blka, models5_blka_blh, 0.4, 0, '');


% For Fig 6A, comparison of blks AND blka
% Here the trick is that 'blh' is the treatment condition (-H -Kdrs or -H -KA) and 'ctl'
% is actually -H.
blks_blka_ranks = intersect(blks_ranks, blka_ranks);
blh_blks_blka_ranks = intersect(blh_ranks, blks_blka_ranks);

models5_blh_blks_blka = models_only_ranks(models5_blh,blks_blka_ranks);
models5_blks_blka = models_only_ranks(models5_blks,blks_blka_ranks);
models5_blka_blks = models_only_ranks(models5_blka,blks_blka_ranks);
VS_struct5_blks_blka = phd_exc_anal_VS(models5_blh_blks_blka, models5_blks_blka, 0.4, 0, '');
VS_struct5_blka_blks = phd_exc_anal_VS(models5_blh_blks_blka, models5_blka_blks, 0.4, 0, '');


%{ 

PLOT ALL THE STUFF

%}

% Scen4 vs 5
elife2016_plot_measure(pr_struct4.pr_nat_hD0, pr_struct5.pr_nat_hD0, {'S inputs' 'SD inputs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure1/Fig1Ei.svg','title_str','Somatic H','custom_ytick',0.2:0.2:1));
elife2016_plot_measure(pr_struct4.pr_nat_hD1, pr_struct5.pr_nat_hD1, {'S inputs' 'SD inputs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure1/Fig1Eii.svg','title_str','Somatodendritic H','custom_ytick',0.2:0.2:1));

plot_subth_scen45;

%
% Fig 3 Suppl Fig 1
%
plot_fig1_suppl1;
plot_fig1_suppl_syn;
plot_fig1_suppl_Htau;


%
% Fig 2
%

% A - left (nomod)
%A = dlmread('~/data/phd_exc/eLife/fig2/R3_somadend_rank326_h_5e-05_excw_2e-06_inhw_3.5e-06_tstop_20000_injclamp_0.dat');
model_path_A = '~/data/phd_exc/eLife/fig2/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig2/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('filename','Figure2/nomod_psd'));
plot_two_traces(A, B, [0000 10000], 0, fileloc, struct('filename','Figure2/nomod.svg','colorized',1));

% A - middle (3Hz)
%A = dlmread('~/data/phd_exc/eLife/fig2/R3_somadend_rank326_h_5e-05_excw_2e-06_inhw_3.5e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat');
model_path_A = '~/data/phd_exc/eLife/fig2/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig2/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('filename','Figure2/3Hz_psd'));
plot_two_traces(A, B, [0000 10000], 3, fileloc, struct('filename','Figure2/3Hz.svg','colorized',1));

% A - right (8Hz)
%A = dlmread('~/data/phd_exc/eLife/fig2/R3_somadend_rank326_h_5e-05_excw_2e-06_inhw_3.5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat');
model_path_A = '~/data/phd_exc/eLife/fig2/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig2/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('filename','Figure2/8Hz_psd'));
plot_two_traces(A, B, [0000 10000], 8, fileloc, struct('filename','Figure2/8Hz.svg','colorized',1));


% B - power ratios
hD1_idx = [1:3 5:13 15:16]; % idx 4 and 14 missing in ctl (respectively ranks 2050 and 913, both hD1
elife2016_plot_measure(pr_struct5.pr_nat_hD0, pr_struct5.pr_nat_hD0_blh, {'H_{S}' 'H_{S} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HS.svg','custom_ytick',0.2:0.2:1));
elife2016_plot_measure(pr_struct5.pr_nat_hD1(hD1_idx,:), pr_struct5.pr_nat_hD1_blh, {'H_{SD}' 'H_{SD} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HSD.svg','custom_ytick',0.2:0.2:1));

% FOR HLEAK
elife2016_plot_measure(pr_struct_hleak.pr_nat_hD0, pr_struct_hleak.pr_nat_hD0_blh, {'H_{S}' 'H_{S} H_{leak}'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HS_Hleak.svg','custom_ytick',0.2:0.2:1));
elife2016_plot_measure(pr_struct_hleak.pr_nat_hD1, pr_struct_hleak.pr_nat_hD1_blh, {'H_{SD}' 'H_{SD} H_{leak}'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HSD_Hleak.svg','custom_ytick',0.2:0.2:1));


% C - rotation numbers
elife2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5.rotn_hD0_blh, {'H_{S}' 'H_{S} -H'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HS.svg','want_legend',0));
elife2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5.rotn_hD0_blh, {'H_{S}' 'H_{S} -H'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HS_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 3],'FontSize',12));

elife2016_plot_measure(rotn_struct5.rotn_hD1(hD1_idx,:), rotn_struct5.rotn_hD1_blh, {'H_{SD}' 'H_{SD} -H'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HSD.svg','want_legend',0));
elife2016_plot_measure(rotn_struct5.rotn_hD1(hD1_idx,:), rotn_struct5.rotn_hD1_blh, {'H_{SD}' 'H_{SD} -H'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HSD_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 3],'FontSize',12));

% FOR HLEAK
elife2016_plot_measure(rotn_struct_hleak.rotn_hD0, rotn_struct_hleak.rotn_hD0_blh, {'H_{S}' 'H_{S} H_{leak}'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HS_Hleak.svg','want_legend',0));
elife2016_plot_measure(rotn_struct_hleak.rotn_hD1, rotn_struct_hleak.rotn_hD0_blh, {'H_{S}' 'H_{S} H_{leak}'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HS_Hleak_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 3],'FontSize',12));

elife2016_plot_measure(rotn_struct_hleak.rotn_hD1, rotn_struct_hleak.rotn_hD1_blh, {'H_{SD}' 'H_{SD} H_{leak}'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HSD_Hleak.svg','want_legend',0));
elife2016_plot_measure(rotn_struct_hleak.rotn_hD1, rotn_struct_hleak.rotn_hD1_blh, {'H_{SD}' 'H_{SD} H_{leak}'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure2/rotn5_HSD_Hleak_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 3],'FontSize',12));

%
% Fig 2 Suppl Fig 1
%
plot_subth_blh(scen5_meanVm_hD0, scen5_blhp_meanVm_hD0, scen5_blh_meanVm_hD0, scen5_meanVm_hD1, scen5_blhp_meanVm_hD1, scen5_blh_meanVm_hD1, 'Mean V_{m} (mV)', fileloc, 'Figure2/meanVm.svg');
plot_subth_blh(scen5_stdVm_hD0, scen5_blhp_stdVm_hD0, scen5_blh_stdVm_hD0, scen5_stdVm_hD1, scen5_blhp_stdVm_hD1, scen5_blh_stdVm_hD1, 'STD V_{m} (mV)', fileloc, 'Figure2/stdVm.svg');
plot_subth_blh(scen5_spikerate_hD0, scen5_blhp_spikerate_hD0, scen5_blh_spikerate_hD0, scen5_spikerate_hD1, scen5_blhp_spikerate_hD1, scen5_blh_spikerate_hD1, 'Spike rate (Hz)', fileloc, 'Figure2/spikerate.svg');
% see Fig 4 suppl fig 1 for continuation with blks, blka

% REVISION FIGURES

% Showing power ratio on per-morphology basis; below is probably the way to do even normal base in 2B
models5_idx=[1:19 21:29 31:32];
pr_struct5 = phd_exc_anal_pratio(models5(models5_idx),models5_blh, desired_mo,mf);
[cell1_ranks, cell2_ranks] = phd_exc_load_cells_to_ranks(models5(models5_idx));
elife2016_plot_measure(pr_struct5.pr_nat_hD0(intersect(hD0_ranks,cell1_ranks),:), pr_struct5.pr_nat_hD0_blh(intersect(hD0_ranks_blh,cell1_ranks),:), {'H_{S}' 'H_{S} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HS_cell1.svg','custom_ytick',0.2:0.2:1,'title_str','Morphology 1'));
% Note can only go up to 11Hz with cell 2 hD0 because of so many NaN's in upper Hz, so rmANOVA fails if we don't take this subset. But then need to use custom files for it all, sigh.
elife2016_plot_measure_mf11(pr_struct5.pr_nat_hD0(intersect(hD0_ranks,cell2_ranks),:), pr_struct5.pr_nat_hD0_blh(intersect(hD0_ranks_blh,cell2_ranks),:), {'H_{S}' 'H_{S} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HS_cell2.svg','custom_ytick',0.2:0.2:1,'dmf',1:11,'title_str','Morphology 2'));

elife2016_plot_measure(pr_struct5.pr_nat_hD1(intersect(hD1_ranks,cell1_ranks)-16,:), pr_struct5.pr_nat_hD1_blh(intersect(hD1_ranks_blh,cell1_ranks)-16,:), {'H_{SD}' 'H_{SD} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HSD_cell1.svg','custom_ytick',0.2:0.2:1,'title_str','Morphology 1'));
elife2016_plot_measure(pr_struct5.pr_nat_hD1(intersect(hD1_ranks,cell2_ranks)-16,:), pr_struct5.pr_nat_hD1_blh(intersect(hD1_ranks_blh,cell2_ranks)-16,:), {'H_{SD}' 'H_{SD} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure2/pratio5_HSD_cell2.svg','custom_ytick',0.2:0.2:1,'title_str','Morphology 2'));



% scen4, blh
%{
elife2016_plot_measure(pr_struct4.pr_nat_hD0, pr_struct4.pr_nat_hD0_blh, {'H_{S}' 'H_{S} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blh/Fig1Ci.png'));
elife2016_plot_measure(pr_struct4.pr_nat_hD1, pr_struct4.pr_nat_hD1_blh, {'H_{SD}' 'H_{SD} -H'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blh/Fig1Cii.png'));
elife2016_plot_measure(rotn_struct4.rotn_hD0, rotn_struct4.rotn_hD0_blh, {'H_{S}' 'H_{S} -H'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','blh/Fig1Di.png'));
elife2016_plot_measure(rotn_struct4.rotn_hD1, rotn_struct4.rotn_hD1_blh, {'H_{SD}' 'H_{SD} -H'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','blh/Fig1Dii.png'));
%}

% scen 5, blh

%
% Fig 3
%

% A
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5.VS_hD1, {'H_S' 'H_{SD}'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure3/VS_hD0_hD1.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));

% B
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5.VS_hD0_blh, {'H_S' 'H_S -H'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure3/VS_hD0.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));
elife2016_plot_measure(VS_struct5.VS_hD1(hD1_idx,:), VS_struct5.VS_hD1_blh, {'H_{SD}' 'H_{SD} -H'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure3/VS_hD1.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));
%unneeded-but-good%elife2016_plot_measure(VS_struct5.VS_hD0_blh(hD1_idx,:), VS_struct5.VS_hD1_blh, {'H_S -H' 'H_{SD} -H'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure3/VS_hD0_blh_hD1_blh.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));

%NO%elife2016_plot_measure(am_struct5.am_hD0, am_struct5.am_hD1, {'H_S' 'H_{SD}'}, 'Angular mean (rad)', fileloc, struct('want_scatter',1,'want_boxplot',1,'filename','Figure3/am_hD0_hD1.svg'));
%NO%elife2016_plot_measure(am_struct5.am_hD1(hD1_idx,:), am_struct5.am_hD1_blh, {'H_{SD}' 'H_{SD} -H'}, 'Angular mean (rad)', fileloc, struct('want_scatter',1,'want_boxplot',1,'filename','Figure3/am_hD1.svg'));

% C
rose_plots(models5(hD0_ranks5), models5(hD1_ranks5), 3, {'H_S', 'H_{SD}'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure3/rose_3Hz_hD0_hD1.svg'),'legend_orientation','vertical','FontSize',16));
rose_plots(models5(hD0_ranks5), models5(hD1_ranks5), 5, {'H_S', 'H_{SD}'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure3/rose_5Hz_hD0_hD1.svg'),'legend_orientation','vertical','FontSize',16));
rose_plots(models5(hD0_ranks5), models5(hD1_ranks5), 8, {'H_S', 'H_{SD}'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure3/rose_8Hz_hD0_hD1.svg'),'legend_orientation','vertical','FontSize',16));
rose_plots(models5(hD0_ranks5), models5(hD1_ranks5), 12, {'H_S', 'H_{SD}'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure3/rose_12Hz_hD0_hD1.svg'),'legend_orientation','vertical','FontSize',16));
rose_plots(models5(hD0_ranks5), models5(hD1_ranks5), 16, {'H_S', 'H_{SD}'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure3/rose_16Hz_hD0_hD1.svg'),'legend_orientation','vertical','FontSize',16));
% end C

% D

% 3Hz
freq=3;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/3, 'Rank 26, H_S, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank26_mf3.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/3, 'Rank 556, H_S, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank556_mf3.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/3, 'Rank 109, H_{SD}, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank109_mf3.png'));

% 5Hz
freq=5;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_5_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/5, 'Rank 26, H_S, 5Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank26_mf5.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_5_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/5, 'Rank 556, H_S, 5Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank556_mf5.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_5_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/5, 'Rank 109, H_{SD}, 5Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank109_mf5.png'));

% 8Hz
freq=8;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/8, 'Rank 26, H_S, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank26_mf8.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 556, H_S, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank556_mf8.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 109, H_{SD}, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank109_mf8.png'));

% 12Hz
freq=12;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_12_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/12, 'Rank 26, H_S, 12Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank26_mf12.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_12_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/12, 'Rank 556, H_S, 12Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank556_mf12.png'));

model_path = '~/data/phd_exc/eLife/fig3/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_12_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/12, 'Rank 109, H_{SD}, 12Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure3/cum_spikes_rank109_mf12.png'));
% end D



%
% Fig 4
%

% A
topdir = '~/bigdata/scinet/scratch/O-LM_runs/phd_exc/scen5_mod_11/';
avg_end_Vms_ctl_hD0 = cum_spikes_load_sets(topdir, ranks_hD0, struct('verbose',1));

% A
model_path = '~/data/phd_exc/eLife/fig4/ctl/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.mod5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_ctl_rank556.png'));

model_path = '~/data/phd_exc/eLife/fig4/ctl/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.mod5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD}', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_ctl_rank109.png'));
% end A

% B
model_path = '~/data/phd_exc/eLife/fig4/blh/R3_somadend_rank556_h_0_excw_4e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.blh5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_blh_rank556.png'));

model_path = '~/data/phd_exc/eLife/fig4/blh/R3_somadend_rank109_h_0_excw_7.8e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.blh5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} -H', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_blh_rank109.png'));
% end B

% C
model_path = '~/data/phd_exc/eLife/fig4/blks/R3_somadend_rank556_h_0_Kdrs_0_excw_3.6e-06_inhw_5e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.blks5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S -H -Kdrs', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_blks_rank556.png'));

model_path = '~/data/phd_exc/eLife/fig4/blks/R3_somadend_rank109_h_0_Kdrs_0_excw_2.2e-06_inhw_4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.blks5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} -H -Kdrs', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_blks_rank109.png'));
% end C

% D
model_path = '~/data/phd_exc/eLife/fig4/blka/R3_somadend_rank556_h_0_Kdrs_0.00023_KA_0_excw_2.4e-06_inhw_5e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.blka5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S -H -KA', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_blka_rank556.png'));

model_path = '~/data/phd_exc/eLife/fig4/blka/R3_somadend_rank109_h_0_Kdrs_0.0042_KA_0_excw_6.75e-06_inhw_4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.blka5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} -H -KA', 1, 1, sprintf('%s/%s', fileloc, 'Figure4/cum_spikes_ahp_blka_rank109.png'));
% end D

% REVISION FIGURES
% 
% Fig 4 Suppl Fig 1
%
plot_subth_blka(scen5_meanVm_hD0, scen5_blh_meanVm_hD0, scen5_blh_blka_meanVm_hD0, scen5_meanVm_hD1, scen5_blh_meanVm_hD1, scen5_blh_blka_meanVm_hD1, 'Mean V_{m} (mV)', fileloc, 'Figure2/blh_blka_meanVm.svg');
plot_subth_blka(scen5_stdVm_hD0, scen5_blh_stdVm_hD0, scen5_blh_blka_stdVm_hD0, scen5_stdVm_hD1, scen5_blh_stdVm_hD1, scen5_blh_blka_stdVm_hD1, 'STD V_{m} (mV)', fileloc, 'Figure2/blh_blka_stdVm.svg');
plot_subth_blka(scen5_spikerate_hD0, scen5_blh_spikerate_hD0, scen5_blh_blka_spikerate_hD0, scen5_spikerate_hD1, scen5_blh_spikerate_hD1, scen5_blh_blka_spikerate_hD1, 'Spike rate (Hz)', fileloc, 'Figure2/blh_blka_spikerate.svg');

plot_subth_blks(scen5_meanVm_hD0, scen5_blh_meanVm_hD0, scen5_blh_blks_meanVm_hD0, scen5_meanVm_hD1(2:16), scen5_blh_meanVm_hD1(2:16), scen5_blh_blks_meanVm_hD1, 'Mean V_{m} (mV)', fileloc, 'Figure2/blh_blks_meanVm.svg');
plot_subth_blks(scen5_stdVm_hD0, scen5_blh_stdVm_hD0, scen5_blh_blks_stdVm_hD0, scen5_stdVm_hD1(2:16), scen5_blh_stdVm_hD1(2:16), scen5_blh_blks_stdVm_hD1, 'STD V_{m} (mV)', fileloc, 'Figure2/blh_blks_stdVm.svg');
plot_subth_blks(scen5_spikerate_hD0, scen5_blh_spikerate_hD0, scen5_blh_blks_spikerate_hD0, scen5_spikerate_hD1(2:16), scen5_blh_spikerate_hD1(2:16), scen5_blh_blks_spikerate_hD1, 'Spike rate (Hz)', fileloc, 'Figure2/blh_blks_spikerate.svg');


%
% Fig 5
%


% A pratios
elife2016_plot_measure(pr_struct5_blks.pr_nat_hD1, pr_struct5_blks.pr_nat_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -Kdrs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/pratio5_blks_hD1.svg','custom_ytick',0.2:0.2:1,'want_ctl_bg',1,'third',pr_struct5.pr_nat_hD1));
elife2016_plot_measure(pr_struct5_blka.pr_nat_hD1, pr_struct5_blka.pr_nat_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/pratio5_blka_hD1.svg','custom_ytick',0.2:0.2:1,'want_ctl_bg',1,'third',pr_struct5.pr_nat_hD1));
% end A

% B rotn
elife2016_plot_measure(rotn_struct5_blks.rotn_hD1, rotn_struct5_blks.rotn_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blks_hD1.svg','want_ctl_bg',1,'third',rotn_struct5.rotn_hD1));
elife2016_plot_measure(rotn_struct5_blks.rotn_hD1, rotn_struct5_blks.rotn_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blks_hD1_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 2],'FontSize',12,'want_ctl_bg',1,'third',rotn_struct5.rotn_hD1));
elife2016_plot_measure(rotn_struct5_blka.rotn_hD1, rotn_struct5_blka.rotn_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD1.svg','want_ctl_bg',1,'third',rotn_struct5.rotn_hD1));
elife2016_plot_measure(rotn_struct5_blka.rotn_hD1, rotn_struct5_blka.rotn_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD1_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 2],'FontSize',12,'want_ctl_bg',1,'third',rotn_struct5.rotn_hD1));
% end B

% C pratios
elife2016_plot_measure(pr_struct5_blks.pr_nat_hD0, pr_struct5_blks.pr_nat_hD0_blh, {'H_{S} -H' 'H_{S} -H -Kdrs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/pratio5_blks_hD0.svg','custom_ytick',0.2:0.2:1,'want_ctl_bg',1,'third',pr_struct5.pr_nat_hD0));
elife2016_plot_measure(pr_struct5_blka.pr_nat_hD0, pr_struct5_blka.pr_nat_hD0_blh, {'H_{S} -H' 'H_{S} -H -KA'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/pratio5_blka_hD0.svg','custom_ytick',0.2:0.2:1,'want_ctl_bg',1,'third',pr_struct5.pr_nat_hD0));
% end C

% D rotn
elife2016_plot_measure(rotn_struct5_blks.rotn_hD0, rotn_struct5_blks.rotn_hD0_blh, {'H_{S} -H' 'H_{S} -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blks_hD0.svg','want_ctl_bg',1,'third',rotn_struct5.rotn_hD0));
elife2016_plot_measure(rotn_struct5_blks.rotn_hD0, rotn_struct5_blks.rotn_hD0_blh, {'H_{S} -H' 'H_{S} -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blks_hD0_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 2],'FontSize',12,'want_ctl_bg',1,'third',rotn_struct5.rotn_hD0));
elife2016_plot_measure(rotn_struct5_blka.rotn_hD0, rotn_struct5_blka.rotn_hD0_blh, {'H_{S} -H' 'H_{S} -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD0.svg','want_ctl_bg',1,'third',rotn_struct5.rotn_hD0));
elife2016_plot_measure(rotn_struct5_blka.rotn_hD0, rotn_struct5_blka.rotn_hD0_blh, {'H_{S} -H' 'H_{S} -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD0_zoomed.svg','dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 2],'FontSize',12,'want_ctl_bg',1,'third',rotn_struct5.rotn_hD0));
% end D


%
% Fig 6
%

% A
elife2016_plot_measure(VS_struct5_blks_blka.VS_hD1_blh, VS_struct5_blka_blks.VS_hD1_blh, {'H_{SD} -H -Kdrs' 'H_{SD} -H -KA'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure6/A_VS_blks_blka.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));

% B
elife2016_plot_measure(VS_struct5_blks.VS_hD1, VS_struct5_blks.VS_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -Kdrs'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure6/B_VS_hD1_blks.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical','want_ctl_bg',1,'third',VS_struct5.VS_hD1));
elife2016_plot_measure(VS_struct5_blka.VS_hD1, VS_struct5_blka.VS_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure6/B_VS_hD1_blka.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical','want_ctl_bg',1,'third',VS_struct5.VS_hD1));

% C
rose_plots(models5_blks(hD1_ranks5), models5_blka_hD1, 3, {'H_{SD} -H -Kdrs', 'H_{SD} -H -KA'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure3/C_rose_3Hz_hD1_blks_blka.svg'),'legend_orientation','vertical','FontSize',16,'want_ctl_bg',1,'third',models5_blh(hD1_ranks5)));
rose_plots(models5_blks(hD1_ranks5), models5_blka_hD1, 5, {'H_{SD} -H -Kdrs', 'H_{SD} -H -KA'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure6/C_rose_5Hz_hD1_blks_blka.svg'),'legend_orientation','vertical','FontSize',16,'want_ctl_bg',1,'third',models5_blh(hD1_ranks5)));
rose_plots(models5_blks(hD1_ranks5), models5_blka_hD1, 8, {'H_{SD} -H -Kdrs', 'H_{SD} -H -KA'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure6/C_rose_8Hz_hD1_blks_blka.svg'),'legend_orientation','vertical','FontSize',16,'want_ctl_bg',1,'third',models5_blh(hD1_ranks5)));
rose_plots(models5_blks(hD1_ranks5), models5_blka_hD1, 12, {'H_{SD} -H -Kdrs', 'H_{SD} -H -KA'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure6/C_rose_12Hz_hD1_blks_blka.svg'),'legend_orientation','vertical','FontSize',16,'want_ctl_bg',1,'third',models5_blh(hD1_ranks5)));
rose_plots(models5_blks(hD1_ranks5), models5_blka_hD1, 16, {'H_{SD} -H -Kdrs', 'H_{SD} -H -KA'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure6/C_rose_16Hz_hD1_blks_blka.svg'),'legend_orientation','vertical','FontSize',16,'want_ctl_bg',1,'third',models5_blh(hD1_ranks5)));
% end C

% D

% 3Hz
freq=3;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig6/blks/R3_somadend_rank109_h_0_Kdrs_0_excw_2.2e-06_inhw_4e-06_tstop_30000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} -H -Kdrs, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure6/D_cum_spikes_rank109_blks_mf3.png'));

model_path = '~/data/phd_exc/eLife/fig6/blka/R3_somadend_rank109_h_0_Kdrs_0.0042_KA_0_excw_6.75e-06_inhw_4e-06_tstop_30000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} -H -KA, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure6/D_cum_spikes_rank109_blka_mf3.png'));

% 5Hz
freq=5;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig6/blks/R3_somadend_rank109_h_0_Kdrs_0_excw_2.2e-06_inhw_4e-06_tstop_30000_modfreq_5_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} -H -Kdrs, 5Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure6/D_cum_spikes_rank109_blks_mf5.png'));

model_path = '~/data/phd_exc/eLife/fig6/blka/R3_somadend_rank109_h_0_Kdrs_0.0042_KA_0_excw_6.75e-06_inhw_4e-06_tstop_30000_modfreq_5_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} -H -KA, 5Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure6/D_cum_spikes_rank109_blka_mf5.png'));

% 8Hz
freq=8;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig6/blks/R3_somadend_rank109_h_0_Kdrs_0_excw_2.2e-06_inhw_4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} -H -Kdrs, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure6/D_cum_spikes_rank109_blks_mf8.png'));

model_path = '~/data/phd_exc/eLife/fig6/blka/R3_somadend_rank109_h_0_Kdrs_0.0042_KA_0_excw_6.75e-06_inhw_4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} -H -KA, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure6/D_cum_spikes_rank109_blka_mf8.png'));

% 12Hz
freq=12;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig6/blks/R3_somadend_rank109_h_0_Kdrs_0_excw_2.2e-06_inhw_4e-06_tstop_30000_modfreq_12_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} -H -Kdrs, 12Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure6/D_cum_spikes_rank109_blks_mf12.png'));


%
% Fig 7
%

% A - top (3Hz)
model_path_A = '~/data/phd_exc/eLife/fig2/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig7/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('filename','Figure7/3Hz_psd'));
plot_two_traces(A, B, [0000 10000], 3, fileloc, struct('filename','Figure7/3Hz.svg','colorized',1));

% A - middle (8Hz)
model_path_A = '~/data/phd_exc/eLife/fig2/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig7/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('filename','Figure7/8Hz_psd'));
plot_two_traces(A, B, [0000 10000], 8, fileloc, struct('filename','Figure7/8Hz.svg','colorized',1));

% A - bottom (10Hz)
model_path_A = '~/data/phd_exc/eLife/fig7/ctl/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_10_modulation_0.4_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig7/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_10_modulation_0.4_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('filename','Figure7/10Hz_psd'));
plot_two_traces(A, B, [0000 10000], 10, fileloc, struct('filename','Figure7/10Hz.svg','colorized',1));

% B - power ratios
%hD1_idx = [1:3 5:13 15:16]; % idx 4 and 14 missing in ctl (respectively ranks 2050 and 913, both hD1
elife2016_plot_measure(pr_struct5.pr_nat_hD0, pr_struct5_cAMP.pr_nat_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure7/B_pratio5_hD0_cAMP.svg','custom_ytick',0.2:0.2:1));
elife2016_plot_measure(pr_struct5.pr_nat_hD1, pr_struct5_cAMP.pr_nat_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure7/B_pratio5_hD1_cAMP.svg','custom_ytick',0.2:0.2:1));

% C - rotation numbers
elife2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5_cAMP.rotn_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure7/B_rotn5_hD0_cAMP.svg','want_legend',1));
elife2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5_cAMP.rotn_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure7/B_rotn5_hD0_cAMP_zoomed.svg','want_legend',0,'dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 2.5],'FontSize',12));

elife2016_plot_measure(rotn_struct5.rotn_hD1, rotn_struct5_cAMP.rotn_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure7/B_rotn5_hD1_cAMP.svg','want_legend',1));
elife2016_plot_measure(rotn_struct5.rotn_hD1, rotn_struct5_cAMP.rotn_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure7/B_rotn5_hD1_cAMP_zoomed.svg','want_legend',0,'dmf',4:11,'zoomed',1,'PaperPosition',[0 0 3 2.5],'FontSize',12));


%
% Fig 8
%

% A
elife2016_plot_measure(VS_struct5_cAMP.VS_hD0, VS_struct5_cAMP.VS_hD1, {'H_{S} +cAMP' 'H_{SD} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure8/A_VS_cAMP.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));

% B
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5_cAMP.VS_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure8/B_VS_hD0_cAMP.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));
elife2016_plot_measure(VS_struct5.VS_hD1, VS_struct5_cAMP.VS_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure8/B_VS_hD1_cAMP.svg','custom_ytick',0.2:0.2:1,'legend_orientation','vertical'));

% C
rose_plots(models5(hD0_ranks5), models5_cAMP(hD0_ranks5_cAMP), 3, {'H_{S}', 'H_{S} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure8/C_rose_3Hz_hD0_cAMP.svg'),'legend_orientation','vertical','FontSize',16));
rose_plots(models5(hD1_ranks5), models5_cAMP(hD1_ranks5_cAMP), 3, {'H_{SD}', 'H_{SD} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure8/C_rose_3Hz_hD1_cAMP.svg'),'legend_orientation','vertical','FontSize',16));

rose_plots(models5(hD0_ranks5), models5_cAMP(hD0_ranks5_cAMP), 8, {'H_{S}', 'H_{S} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure8/C_rose_8Hz_hD0_cAMP.svg'),'legend_orientation','vertical','FontSize',16));
rose_plots(models5(hD1_ranks5), models5_cAMP(hD1_ranks5_cAMP), 8, {'H_{SD}', 'H_{SD} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure8/C_rose_8Hz_hD1_cAMP.svg'),'legend_orientation','vertical','FontSize',16));

rose_plots(models5(hD0_ranks5), models5_cAMP(hD0_ranks5_cAMP), 10, {'H_{S}', 'H_{S} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure8/C_rose_10Hz_hD0_cAMP.svg'),'legend_orientation','vertical','FontSize',16));
rose_plots(models5(hD1_ranks5), models5_cAMP(hD1_ranks5_cAMP), 10, {'H_{SD}', 'H_{SD} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure8/C_rose_10Hz_hD1_cAMP.svg'),'legend_orientation','vertical','FontSize',16));

% end C

% D

% 3Hz
freq=3;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig8/cAMP/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 26, H_{S} +cAMP, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank26_cAMP_mf3.png'));

model_path = '~/data/phd_exc/eLife/fig8/cAMP/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 556, H_{S} +cAMP, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank556_cAMP_mf3.png'));

model_path = '~/data/phd_exc/eLife/fig7/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_3_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} +cAMP, 3Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank109_cAMP_mf3.png'));

% 8Hz
freq=8;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig8/cAMP/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 26, H_{S} +cAMP, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank26_cAMP_mf8.png'));

model_path = '~/data/phd_exc/eLife/fig8/cAMP/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 556, H_{S} +cAMP, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank556_cAMP_mf8.png'));

model_path = '~/data/phd_exc/eLife/fig7/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} +cAMP, 8Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank109_cAMP_mf8.png'));

% 10Hz
freq=10;
yt=[1e3/freq/2:1e3/freq:20000];

model_path = '~/data/phd_exc/eLife/fig8/cAMP/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_10_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 26, H_{S} +cAMP, 10Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank26_cAMP_mf10.png'));

model_path = '~/data/phd_exc/eLife/fig8/cAMP/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_10_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 556, H_{S} +cAMP, 10Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank556_cAMP_mf10.png'));

model_path = '~/data/phd_exc/eLife/fig7/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_10_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 1000/freq, 'Rank 109, H_{SD} +cAMP, 10Hz', 1, 1, sprintf('%s/%s', fileloc, 'Figure8/D_cum_spikes_rank109_cAMP_mf10.png'));



%%%%%%%%%%%%
% OLD starts
%%%%%%%%%%%%

% C VS
elife2016_plot_measure(VS_struct5_blks.VS_hD1, VS_struct5_blks.VS_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -Kdrs'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/VS_struct5_blks_hD1.svg','custom_ytick',0.2:0.2:1));
elife2016_plot_measure(VS_struct5_blka.VS_hD1, VS_struct5_blka.VS_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/VS_struct5_blka_hD1.svg','custom_ytick',0.2:0.2:1));
% end C

% D am
elife2016_plot_measure(am_struct5_blks.am_hD1, am_struct5_blks.am_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -Kdrs'}, 'Angular mean', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/am_struct5_blks_hD1.svg'));
elife2016_plot_measure(am_struct5_blka.am_hD1, am_struct5_blka.am_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Angular mean', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/am_struct5_blka_hD1.svg'));
% end D

% E rose plots
rose_plots(models_only_ranks(models5_blh_blks,ranks_hD1), models_only_ranks(models5_blks_blh,ranks_hD1), 8, {'H_{SD} -H', 'H_{SD} -H -Kdrs'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure5/rose_blks_hD1.svg')));
rose_plots(models_only_ranks(models5_blh_blka,ranks_hD1), models_only_ranks(models5_blka_blh,ranks_hD1), 8, {'H_{SD} -H', 'H_{SD} -H -KA'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure5/rose_blka_hD1.svg')));
% end E
% OLD ends


%
% Fig 6
%

% H_S
model_path_A = '~/data/phd_exc/eLife/fig6/ctl/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig6/cAMP/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('filename','Figure6/rank556_psd_ctl_cAMP'));
plot_two_traces(A, B, [0000 10000], 8, fileloc, struct('filename','Figure6/rank556_traces_ctl_cAMP.svg'))

% H_SD
model_path_A = '~/data/phd_exc/eLife/fig6/ctl/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
model_path_B = '~/data/phd_exc/eLife/fig6/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
A = dlmread(model_path_A);
B = dlmread(model_path_B);
elife2016_plot_psds(model_path_A, model_path_B, fileloc, struct('ylim',[0 2e-4],'filename','Figure6/rank109_psd_ctl_cAMP'));
plot_two_traces(A, B, [0000 10000], 8, fileloc, struct('filename','Figure6/rank109_traces_ctl_cAMP.svg'))


% pratio and rotn obtained previously... find below/elsewhere and paste here


%
% Fig 7
%

% A VS
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5_cAMP.VS_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure7/VS_struct5_ctl_cAMP_hD0.svg'));
elife2016_plot_measure(VS_struct5.VS_hD1, VS_struct5_cAMP.VS_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure7/VS_struct5_ctl_cAMP_hD1.svg'));
% end A

% B am
elife2016_plot_measure(am_struct5.am_hD0, am_struct5_cAMP.am_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure7/am_struct5_ctl_cAMP_hD0.svg'));
elife2016_plot_measure(am_struct5.am_hD1, am_struct5_cAMP.am_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure7/am_struct5_ctl_cAMP_hD1.svg'));
% end B

% C
model_path = '~/data/phd_exc/eLife/fig6/cAMP/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 556, H_S +cAMP', 1, 1, sprintf('%s/%s', fileloc, 'Figure7/cum_spikes_rank556_mf8.png'));

model_path = '~/data/phd_exc/eLife/fig6/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 109, H_{SD} +cAMP', 1, 1, sprintf('%s/%s', fileloc, 'Figure7/cum_spikes_rank109_mf8.png'));
% end C

% D rose plots
rose_plots(models5(hD0_ranks5), models5_cAMP(hD0_ranks5_cAMP), 8, {'H_S', 'H_S +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure7/rose_ctl_cAMP_hD0.svg')));
rose_plots(models5(hD1_ranks5), models5_cAMP(hD1_ranks5_cAMP), 8, {'H_{SD}', 'H_{SD} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure7/rose_ctl_cAMP_hD1.svg')));
rose_plots(models_only_ranks(models5_blh_blks,ranks_hD1), models_only_ranks(models5_blks_blh,ranks_hD1), 8, {'H_{SD} -H', 'H_{SD} -H -Kdrs'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure5/rose_blks_hD1.svg')));
rose_plots(models_only_ranks(models5_blh_blka,ranks_hD1), models_only_ranks(models5_blka_blh,ranks_hD1), 8, {'H_{SD} -H', 'H_{SD} -H -KA'}, struct('filename',sprintf('%s/%s', fileloc, 'Figure5/rose_blka_hD1.svg')));
% end D


%%%%%%%%%%%%
% OLD STUFF
%%%%%%%%%%%%

%
% Fig 4 - precision and phase of firing
%

%%%%%%% S %%%%%%%%%
% Fig. 4Ai
elife2016_plot_measure(VS_struct4.VS_hD0, VS_struct4.VS_hD1, {'H_S' 'H_{SD}'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig4Ai.png'));
% Fig. 4Aii
elife2016_plot_measure(am_struct4.am_hD0, am_struct4.am_hD1, {'H_S' 'H_{SD}'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig4Aii.png'));
% Fig. 4Aiii
model_path = 'eLife/fig4/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 26, H_{S}', 1, 1, sprintf('%s/%s', fileloc, 'Fig4Aiii.png'));
% Fig. 4Aiv
rose_plots(models4(hD0_ranks4), models4(hD1_ranks4), 8, {'H_S', 'H_{SD}'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig4Aiv.png')));

%%%%%%% SD %%%%%%%%%
% Fig. 4Bi
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5.VS_hD1, {'H_S' 'H_{SD}'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig4Bi.png'));
% Fig. 4Bii
elife2016_plot_measure(am_struct5.am_hD0, am_struct5.am_hD1, {'H_S' 'H_{SD}'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig4Bii.png'));
% Fig. 4Biii
model_path = 'eLife/fig4/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 109, H_{SD}', 1, 1, sprintf('%s/%s', fileloc, 'Fig4Biii.png'));
% Fig. 4Biv
rose_plots(models5(hD0_ranks5), models5(hD1_ranks5), 8, {'H_S', 'H_{SD}'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig4Biv.png')));

%
% Fig. 5
%

%%%%%%% S %%%%%%%%%
% Fig. 5Ei
elife2016_plot_measure(pr_struct4.pr_nat_hD0, pr_struct4_cAMP.pr_nat_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig5Ei.png'));
% Fig. 5Eii
elife2016_plot_measure(rotn_struct4.rotn_hD0, rotn_struct4_cAMP.rotn_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig5Eii.png'));
% Fig. 5Eiii
elife2016_plot_measure(pr_struct4.pr_nat_hD1, pr_struct4_cAMP.pr_nat_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig5Eiii.png'));
% Fig. 5Eiv
elife2016_plot_measure(rotn_struct4.rotn_hD1, rotn_struct4_cAMP.rotn_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig5Eiv.png'));

%%%%%%% SD %%%%%%%%%
% Fig. 5Fi
elife2016_plot_measure(pr_struct5.pr_nat_hD0, pr_struct5_cAMP.pr_nat_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure6/pratio5_cAMP_HS.svg'));
% Fig. 5Fii
elife2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5_cAMP.rotn_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure6/rotn5_cAMP_HS.svg'));
% Fig. 5Fiii
elife2016_plot_measure(pr_struct5.pr_nat_hD1, pr_struct5_cAMP.pr_nat_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure6/pratio5_cAMP_HSD.svg'));
% Fig. 5Fiv
elife2016_plot_measure(rotn_struct5.rotn_hD1, rotn_struct5_cAMP.rotn_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure6/rotn5_cAMP_HSD.svg'));

%
% Fig 6 - precision and phase of firing (cAMP)
%

%%%%%%% S %%%%%%%%%
% Fig. 6Ai
elife2016_plot_measure(VS_struct4.VS_hD0, VS_struct4_cAMP.VS_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Ai_scen4.png'));
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5_cAMP.VS_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Ai_scen5.png'));
% Fig. 6Aii
elife2016_plot_measure(am_struct4.am_hD0, am_struct4_cAMP.am_hD0, {'H_S' 'H_{S} +cAMP'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Aii_scen4.png'));
elife2016_plot_measure(am_struct5.am_hD0, am_struct5_cAMP.am_hD0, {'H_S' 'H_{S} +cAMP'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Aii_scen5.png'));
% Fig. 6Aiii
model_path = 'eLife/fig6/cAMP_traces/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 26, H_{S} +cAMP', 1, 1, sprintf('%s/%s', fileloc,'Fig6Aiii.png'));

model_path = 'eLife/fig6/cAMP2_traces/R3_somadend_rank26_h_5e-05_excw_2e-06_inhw_8e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 26, H_{S} +cAMP2', 1, 1, sprintf('%s/%s', fileloc,'Fig6Aiii.png'));

% Fig. 6Aiv
rose_plots(models4(hD0_ranks4), models4_cAMP(hD0_ranks4_cAMP), 8, {'H_S', 'H_{S} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Aiv_scen4.png')));
rose_plots(models5(hD0_ranks5), models5_cAMP(hD0_ranks5_cAMP), 8, {'H_S', 'H_{S} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Aiv_scen5.png')));

% cAMP2 (H_S)
elife2016_plot_measure(VS_struct4_cAMP.VS_hD0, VS_struct4_cAMP2.VS_hD0, {'H_{S} +cAMP' 'H_{S} +cAMP2'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Ai_scen4_cAMP2.png'));
elife2016_plot_measure(VS_struct5_cAMP.VS_hD0, VS_struct5_cAMP2.VS_hD0, {'H_{S} +cAMP' 'H_{S} +cAMP2'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Ai_scen5_cAMP2.png'));
elife2016_plot_measure(am_struct4_cAMP.am_hD0, am_struct4_cAMP2.am_hD0, {'H_{S} +cAMP' 'H_{S} +cAMP2'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Aii_scen4_cAMP2.png'));
elife2016_plot_measure(am_struct5_cAMP.am_hD0, am_struct5_cAMP2.am_hD0, {'H_{S} +cAMP' 'H_{S} +cAMP2'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Aii_scen5_cAMP2.png'));
rose_plots(models4_cAMP(hD0_ranks4_cAMP), models4_cAMP2(hD0_ranks4_cAMP2), 8, {'H_{S} +cAMP', 'H_{S} +cAMP2'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Aiv_scen4_cAMP2.png')));
rose_plots(models5_cAMP(hD0_ranks5_cAMP), models5_cAMP2(hD0_ranks5_cAMP2), 8, {'H_{S} +cAMP', 'H_{S} +cAMP2'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Aiv_scen5_cAMP2.png')));

%%%%%%% SD %%%%%%%%%
% Fig. 6Bi
elife2016_plot_measure(VS_struct4.VS_hD1, VS_struct4_cAMP.VS_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bi_scen4.png'));
elife2016_plot_measure(VS_struct5.VS_hD1, VS_struct5_cAMP.VS_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bi_scen5.png'));
% Fig. 6Bii
elife2016_plot_measure(am_struct4.am_hD1, am_struct4_cAMP.am_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bii_scen4.png'));
elife2016_plot_measure(am_struct5.am_hD1, am_struct5_cAMP.am_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bii_scen5.png'));
% Fig. 6Biii
model_path = 'eLife/fig6/cAMP_traces/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 109, H_{SD} +cAMP', 1, 1, sprintf('%s/%s', fileloc,'Fig6Biii.png'));

model_path = 'eLife/fig6/cAMP2_traces/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 109, H_{SD} +cAMP2', 1, 1, sprintf('%s/%s', fileloc,'Fig6Biii.png'));
% Fig. 6Biv
rose_plots(models4(hD1_ranks4), models4_cAMP(hD1_ranks4_cAMP), 8, {'H_{SD}', 'H_{SD} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Biv_scen4.png')));
rose_plots(models5(hD1_ranks5), models5_cAMP(hD1_ranks5_cAMP), 8, {'H_{SD}', 'H_{SD} +cAMP'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Biv_scen5.png')));

% cAMP2 (H_SD)
elife2016_plot_measure(VS_struct4_cAMP.VS_hD1, VS_struct4_cAMP2.VS_hD1, {'H_{SD} +cAMP' 'H_{SD} +cAMP2'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bi_scen4_cAMP2.png'));
elife2016_plot_measure(VS_struct5_cAMP.VS_hD1, VS_struct5_cAMP2.VS_hD1, {'H_{SD} +cAMP' 'H_{SD} +cAMP2'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bi_scen5_cAMP2.png'));
elife2016_plot_measure(am_struct4_cAMP.am_hD1, am_struct4_cAMP2.am_hD1, {'H_{SD} +cAMP' 'H_{SD} +cAMP2'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bii_scen4_cAMP2.png'));
elife2016_plot_measure(am_struct5_cAMP.am_hD1, am_struct5_cAMP2.am_hD1, {'H_{SD} +cAMP' 'H_{SD} +cAMP2'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig6Bii_scen5_cAMP2.png'));
rose_plots(models4_cAMP(hD1_ranks4_cAMP), models4_cAMP2(hD1_ranks4_cAMP2), 8, {'H_{SD} +cAMP', 'H_{SD} +cAMP2'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Biv_scen4_cAMP2.png')));
rose_plots(models5_cAMP(hD1_ranks5_cAMP), models5_cAMP2(hD1_ranks5_cAMP2), 8, {'H_{SD} +cAMP', 'H_{SD} +cAMP2'}, struct('filename',sprintf('%s/%s', fileloc, 'Fig6Biv_scen5_cAMP2.png')));



%
% Fig. 7 - Post-spike subthreshol dynamics
end_Vms = struct();

%%%%%%% H_S rank 556 %%%%%%%%%
% Fig. 7Ai scen4
model_path = 'eLife/fig7/mod/R3_soma_rank556_h_5e-05_excw_5e-05_inhw_5e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.mod4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S', 1, 1, sprintf('%s/%s', fileloc, 'Fig7Ai.png'));
% Fig. 7Aii scen4 blh
model_path = 'eLife/fig7/mod/R3_soma_rank556_h_0_excw_7e-05_inhw_5e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.blh4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S -H', 1, 1, sprintf('%s/%s', fileloc, 'Fig7Aii.png'));
% Fig. 7Aiii scen4 cAMP
model_path = 'eLife/fig7/cAMP/R3_soma_rank556_h_5e-05_excw_5e-05_inhw_5e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.cAMP4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S +cAMP', 1, 1, sprintf('%s/%s', fileloc, 'Fig7Aiii.png'));
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 556, H_{S} +cAMP', 1, 1, sprintf('%s/%s', fileloc, 'cAMP/rank556_cAMP.png'));

%{
% Fig. 7Aiv scen4 cAMP blh
model_path = 'eLife/fig7/cAMP/R3_soma_rank556_h_0_excw_7e-05_inhw_5e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.cAMP_blh4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S +cAMP -H', 1, 1);
%}
% Fig. 7Aiv
elife2016_plot_subth(end_Vms_rank556, 4, fileloc, struct('want_scatter',1,'want_boxplot',1,'filename','Fig7Aiv.png'))

% Fig. 7Bi scen5
model_path = 'eLife/fig7/mod/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.mod5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S', 1, 1, sprintf('%s/%s', fileloc, 'Fig7Bi.png'));
% Fig. 7Bii scen5 blh
model_path = 'eLife/fig7/mod/R3_somadend_rank556_h_0_excw_4e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.blh5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S -H', 1, 1, sprintf('%s/%s', fileloc, 'Fig7Bii.png'));
% Fig. 7Biii scen5 cAMP
model_path = 'eLife/fig7/cAMP/R3_somadend_rank556_h_5e-05_excw_3e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.cAMP5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S +cAMP', 1, 1, sprintf('%s/%s', fileloc, 'Fig7Biii.png'));
%{
% Fig. 7Biv scen5 cAMP blh
model_path = 'eLife/fig7/cAMP/R3_somadend_rank556_h_0_excw_4e-06_inhw_5e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.cAMP_blh5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S +cAMP -H', 1, 1);
%}
% Fig. 7Biv
elife2016_plot_subth(end_Vms_rank556, 5, fileloc, struct('want_scatter',1,'want_boxplot',1,'filename','Fig7Biv.png'))
% had to use: 
%ax=gca;
%ax.DataAspectRatio = [2 1 1]

%%%%%%% H_SD rank 109 %%%%%%%%%
% Fig. 7Ci scen4
model_path = 'eLife/fig7/mod/R3_soma_rank109_h_1e-05_excw_8e-05_inhw_4e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.mod4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD}', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Ci.png'));
% Fig. 7Cii scen4 blh
model_path = 'eLife/fig7/mod/R3_soma_rank109_h_0_excw_0.000115_inhw_4e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.blh4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} -H', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Cii.png'));
% Fig. 7Ciii scen4 cAMP
model_path = 'eLife/fig7/cAMP/R3_soma_rank109_h_1e-05_excw_8e-05_inhw_4e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.cAMP4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} +cAMP', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Ciii.png'));
%{
% Fig. 7Civ scen4 cAMP blh
model_path = 'eLife/fig7/cAMP/R3_soma_rank109_h_0_excw_0.000115_inhw_4e-05_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.cAMP_blh4 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} +cAMP -H', 1, 1);
%}
% Fig. 7Civ
elife2016_plot_subth(end_Vms_rank109, 4, fileloc, struct('want_scatter',1,'want_boxplot',1,'filename','Fig7Civ.png'))

% Fig. 7Di scen5
model_path = 'eLife/fig7/mod/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.mod5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD}', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Di.png'));
% Fig. 7Dii scen5 blh
model_path = 'eLife/fig7/mod/R3_somadend_rank109_h_0_excw_7.8e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.blh5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} -H', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Dii.png'));
% Fig. 7Diii scen5 cAMP
model_path = 'eLife/fig7/cAMP/R3_somadend_rank109_h_1e-05_excw_6e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.cAMP5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} +cAMP', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Diii.png'));
%{
% Fig. 7Div scen5 cAMP blh
model_path = 'eLife/fig7/cAMP/R3_somadend_rank109_h_0_excw_7.8e-06_inhw_4e-06_tstop_20000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.cAMP_blh5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_{SD} +cAMP -H', 1, 1);
%}
% Fig. 7Div
elife2016_plot_subth(end_Vms_rank109, 5, fileloc, struct('want_scatter',1,'want_boxplot',1,'filename','Fig7Div.png'))
% had to use
% ax=gca;
% ax.DataAspectRatio = [1.2 1 1]

%%%%%% -Kdrs, -Ih %%%%%%%%
% Fig. 7Ei
model_path = 'eLife/fig7/Kdrs_exps/R3_somadend_rank556_h_0_Kdrs_0_excw_3.6e-06_inhw_5e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank556.blks5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 556, H_S -H -Kdrs', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Ei.png'));
% Fig. 7Eii
model_path = 'eLife/fig7/Kdrs_exps/R3_somadend_rank109_h_0_Kdrs_0_excw_2.2e-06_inhw_4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank109.blks5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 109, H_S -H -Kdrs', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Eii.png'));

%%%%%% -KA, -Ih %%%%%%%%
% Fig. 7Fi
model_path = 'eLife/fig7/KA_exps/R3_somadend_rank356_h_1e-05_Kdrs_0.0042_KA_0_excw_3e-06_inhw_5.4e-06_tstop_2000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
end_Vms_rank356.blka5 = cum_spikes_ahp_plot(a_t, a_prof, 125, 'Rank 356, H_{SD} -KA', 1, 1,sprintf('%s/%s', fileloc, 'Fig7Fi.png'));
% Fig. 7Dii
%model_path = 'eLife/fig7/KA_exps/


%
% Fig. 8
%

%%%%%%% H_S %%%%%%%%%
% Fig. 8Ai
elife2016_plot_measure(pr_struct5.pr_nat_hD0, pr_struct5_blks.pr_nat_hD0_blh, {'H_S' 'H_S -H -Kdrs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig8Ai.png'));
% Fig. 8Aii
elife2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5_blks.rotn_hD0_blh, {'H_S' 'H_S -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig8Aii.png'));
% Fig. 8Aiii
elife2016_plot_measure(pr_struct5.pr_nat_hD0, pr_struct5_blks.pr_nat_hD1_blh, {'H_S' 'H_{SD} -H -Kdrs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig8Aiii.png'));
% Fig. 8Aiv
elife2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5_blks.rotn_hD1_blh, {'H_S' 'H_{SD} -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig8Aiv.png'));

%%%%%%% H_SD %%%%%%%%%
% Fig. 8Bi
elife2016_plot_measure(pr_struct5.pr_nat_hD1, pr_struct5_blks.pr_nat_hD0_blh, {'H_{SD}' 'H_S -H -Kdrs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig8Bi.png'));
% Fig. 8Bii
elife2016_plot_measure(rotn_struct5.rotn_hD1, rotn_struct5_blks.rotn_hD0_blh, {'H_{SD}' 'H_S -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig8Bii.png'));
% Fig. 8Biii
elife2016_plot_measure(pr_struct5.pr_nat_hD1, pr_struct5_blks.pr_nat_hD1_blh, {'H_{SD}' 'H_{SD} -H -Kdrs'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig8Biii.png'));
% Fig. 8Biv
elife2016_plot_measure(rotn_struct5.rotn_hD1, rotn_struct5_blks.rotn_hD1_blh, {'H_{SD}' 'H_{SD} -H -Kdrs'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig8Biv.png'));


%
% Fig. 9
%

%%%%%%% H_S %%%%%%%%%
% Fig. 9Ai
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5_blks.VS_hD1_blh, {'H_S' 'H_{SD} -H -Kdrs'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig9Ai.png'));
% Fig. 9Aii
elife2016_plot_measure(am_struct5.am_hD0, am_struct5_blks.am_hD1_blh, {'H_S' 'H_{SD} -H -Kdrs'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig9Aii.png'));
% Fig. 9Aiii
model_path = 'eLife/fig7/Kdrs_exps/R3_somadend_rank109_h_0_Kdrs_0_excw_2.2e-06_inhw_4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 109, H_{SD} -H -Kdrs', 1, 1,sprintf('%s/%s', fileloc, 'Fig9Aiii.png'));
% Fig. 9Aiv
rose_plots(models5(hD0_ranks5), models5_blks(hD0_ranks5_blks), 8, {'H_S', 'H_{SD} -H -Kdrs'},struct('filename',sprintf('%s/%s', fileloc, 'Fig9Aiv.png')));

%%%%%%% H_SD1 %%%%%%%%%
% Fig. 9Bi
elife2016_plot_measure(VS_struct5.VS_hD1, VS_struct5_blks.VS_hD0_blh, {'H_{SD}' 'H_S -H -Kdrs'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig9Bi.png'));
% Fig. 9Bii
elife2016_plot_measure(am_struct5.am_hD1, am_struct5_blks.am_hD0_blh, {'H_{SD}' 'H_S -H -Kdrs'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig9Bii.png'));
% Fig. 9Biii
model_path = 'eLife/fig7/Kdrs_exps/R3_somadend_rank556_h_0_Kdrs_0_excw_3.6e-06_inhw_5e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 556, H_S -H -Kdrs', 1, 1, sprintf('%s/%s', fileloc, 'Fig9Biii.png'));
% Fig. 9Biv
rose_plots(models5(hD1_ranks5), models5_blks(hD0_ranks5_blks), 8, {'H_{SD}', 'H_S -H -Kdrs'}, struct('filename', sprintf('%s/%s', fileloc, 'Fig9Biv.png')));

%%%%%%% H_SD2 %%%%%%%%%
% Fig. 9Ci
elife2016_plot_measure(VS_struct5.VS_hD1, VS_struct5_blks.VS_hD1_blh, {'H_{SD}' 'H_{SD} -H -Kdrs'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig9Ci.png'));
% Fig. 9Cii
elife2016_plot_measure(am_struct5.am_hD1, am_struct5_blks.am_hD1_blh, {'H_{SD}' 'H_{SD} -H -Kdrs'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig9Cii.png'));
% Fig. 9Ciii
model_path = 'eLife/fig7/Kdrs_exps/R3_somadend_rank356_h_0_Kdrs_0_excw_1.2e-06_inhw_5.4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 356, H_{SD} -H -Kdrs', 1, 1, sprintf('%s/%s', fileloc, 'Fig9Ciii.png'));
% Fig. 9Civ
rose_plots(models5(hD1_ranks5), models5_blks(hD1_ranks5_blks), 8, {'H_{SD}', 'H_{SD} -H -Kdrs'}, struct('filename', sprintf('%s/%s', fileloc, 'Fig9Civ.png')));


%
% Fig. 10
%
blka_prefix = 'blka/';

%%%%%%% H_S %%%%%%%%%
elife2016_plot_measure(pr_struct5.pr_nat_hD0_blh, pr_struct5_blka.pr_nat_hD0_blh, {'H_S -H' 'H_S -H -KA'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/pratio5_blka_hD00.svg'));
elife2016_plot_measure(rotn_struct5.rotn_hD0_blh, rotn_struct5_blka.rotn_hD0_blh, {'H_S -H' 'H_S -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD00.svg'));
elife2016_plot_measure(pr_struct5.pr_nat_hD0_blh, pr_struct5_blka.pr_nat_hD1_blh, {'H_S -H' 'H_{SD} -H -KA'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/pratio5_blka_hD01.svg'));
elife2016_plot_measure(rotn_struct5.rotn_hD0_blh, rotn_struct5_blka.rotn_hD1_blh, {'H_S -H' 'H_{SD} -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD01.svg',blka_prefix)));

%%%%%%% H_SD %%%%%%%%%
elife2016_plot_measure(pr_struct5.pr_nat_hD1_blh, pr_struct5_blka.pr_nat_hD0_blh, {'H_{SD} -H' 'H_S -H -KA'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Figure5/pratio5_blka_hD10.svg'));
elife2016_plot_measure(rotn_struct5.rotn_hD1_blh, rotn_struct5_blka.rotn_hD0_blh, {'H_{SD} -H' 'H_S -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD10.svg'));
elife2016_plot_measure(pr_struct5.pr_nat_hD1_blh, pr_struct5_blka.pr_nat_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename',sprintf('Figure5/pratio5_blka_hD11.svg'));
elife2016_plot_measure(rotn_struct5.rotn_hD1_blh, rotn_struct5_blka.rotn_hD1_blh, {'H_{SD} -H' 'H_{SD} -H -KA'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Figure5/rotn5_blka_hD11.svg',blka_prefix)));

%
% Fig. 11
%

%%%%%%% H_S %%%%%%%%%
elife2016_plot_measure(VS_struct5.VS_hD0, VS_struct5_blka.VS_hD1_blh, {'H_S' 'H_{SD} -H -KA'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blka/Fig11Ai.png'));
elife2016_plot_measure(am_struct5.am_hD0, am_struct5_blka.am_hD1_blh, {'H_S' 'H_{SD} -H -KA'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blka/Fig11Aii.png'));

model_path = 'eLife/fig10/R3_somadend_rank109_h_0_Kdrs_0.0042_KA_0_excw_6.75e-06_inhw_4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 109, H_{SD} -H -KA', 1, 1,sprintf('%s/%s', fileloc, 'blka/Fig11Aiii.png'));

rose_plots(models5(hD0_ranks5), models5_blka(hD0_ranks5_blka), 8, {'H_S', 'H_{SD} -H -KA'},struct('filename',sprintf('%s/%s', fileloc, 'blka/Fig11Aiv.png')));

%%%%%%% H_SD1 %%%%%%%%%
elife2016_plot_measure(VS_struct5.VS_hD1, VS_struct5_blka.VS_hD0_blh, {'H_{SD}' 'H_S -H -KA'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blka/Fig11Bi.png'));
elife2016_plot_measure(am_struct5.am_hD1, am_struct5_blka.am_hD0_blh, {'H_{SD}' 'H_S -H -KA'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blka/Fig11Bii.png'));

model_path = 'eLife/fig10/R3_somadend_rank556_h_0_Kdrs_0.00023_KA_0_excw_2.4e-06_inhw_5e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 556, H_S -H -KA', 1, 1, sprintf('%s/%s', fileloc, 'blka/Fig11Biii.png'));

rose_plots(models5(hD1_ranks5), models5_blka(hD0_ranks5_blka), 8, {'H_{SD}', 'H_S -H -KA'}, struct('filename', sprintf('%s/%s', fileloc, 'blka/Fig11Biv.png')));

%%%%%%% H_SD2 %%%%%%%%%
elife2016_plot_measure(VS_struct5.VS_hD1, VS_struct5_blka.VS_hD1_blh, {'H_{SD}' 'H_{SD} -H -KA'}, 'Vector strength', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blka/Fig11Ci.png'));
elife2016_plot_measure(am_struct5.am_hD1, am_struct5_blka.am_hD1_blh, {'H_{SD}' 'H_{SD} -H -KA'}, 'Angular mean (rad)', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','blka/Fig11Cii.png'));

model_path = 'eLife/fig10/R3_somadend_rank356_h_0_Kdrs_0.0042_KA_0_excw_7.4e-06_inhw_5.4e-06_tstop_30000_modfreq_8_modulation_0.4_injclamp_0.dat';
[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, 1, 1);
cum_spikes_plot(a_t, a_prof, yt, 125, 'Rank 356, H_{SD} -H -KA', 1, 1, sprintf('%s/%s', fileloc, 'blka/Fig11Ciii.png'));

rose_plots(models5(hD1_ranks5), models5_blka(hD1_ranks5_blka), 8, {'H_{SD}', 'H_{SD} -H -KA'}, struct('filename', sprintf('%s/%s', fileloc, 'blka/Fig11Civ.png')));
