%{

Plots <whatever> for models across desired modulation frequencies.

Where <whatever> is one of rotation number (rotn_struct), vector strength (VS_struct),
or angular mean (am_struct).

leg_names - cell array of strings for legend

OPTIONS in props:
    want_scatter
    want_boxplot
    want_errorbar
    want_horizline
    title_str
    custom_ylim
    custom_ytick

E.g.,

cns2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5.rotn_hD1, {'H_S' 'H_{SD}'}, 'rotn scen5', '', struct('want_scatter',1));
cns2016_plot_measure(rotn_struct5.rotn_hD0, rotn_struct5.rotn_hD1, {'H_S' 'H_{SD}'}, 'Rotation number', '', struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'custom_ylim',[0 3.2]));

%}
function elife2016_plot_measure(first, second, leg_names, meas_name, fileloc, props)

if nargin < 6
    props = struct();
end
if nargin < 5
    fileloc = '';
end

if isfield(props,'zoomed')
    zoomed=props.zoomed;
else
    zoomed=0;
end
if isfield(props,'FontSize')
    fontsize=props.FontSize;
else
    fontsize=16;
end
if isfield(props,'want_legend')
    want_legend=props.want_legend;
else
    want_legend=1;
end
if isfield(props,'want_scatter')
    want_scatter=props.want_scatter;
else
    want_scatter=0;
end
if isfield(props,'want_boxplot')
    want_boxplot=props.want_boxplot;
else
    want_boxplot=0;
end
if isfield(props,'want_errorbar')
    want_errorbar=props.want_errorbar;
else
    want_errorbar=0;
end
if ~want_scatter && ~want_boxplot && ~want_errorbar
    disp(sprintf('ERROR: need one of want_scatter, want_boxplot, or want_errorbar.'));
    return;
end
if isfield(props,'want_ctl_bg')
    want_ctl_bg=props.want_ctl_bg;
    if want_ctl_bg
        third=props.third;
    end
else
    want_ctl_bg = 0;
end

phd_exc_load_mod; % to get mo and mf
cud; 
if isfield(props,'cud1')
    cud1 = props.cud1;
else
    cud1 = cud_skyBlue;
end
if isfield(props,'cud2')
    cud2 = props.cud2
else
    cud2 = cud_orange;
end

f=figure;
hold on;
if isfield(props,'dmf')
    dmf = props.dmf;
else
    dmf=2:16;
end
dfirst=first(:,dmf);
dsecond=second(:,dmf);
y1=nanmedian(dfirst,1);
y2=nanmedian(dsecond,1);

e_first=std(dfirst,1);
e_second=std(dsecond,1);
Nfreqs=length(y1);

plot(y1,'-','LineWidth',1,'Color',cud1);
plot(y2,'-','LineWidth',1,'Color',cud2);

if want_ctl_bg
disp('YEP THIRD')
    dthird=third(:,dmf);
    y3=nanmedian(dthird,1);
    plot(y3,'-*','LineWidth',2,'Color',cud_grey);
end

if want_scatter
    X1 = phd_exc_load_plotting(size(dfirst,1), Nfreqs);
    X2 = phd_exc_load_plotting(size(dsecond,1), Nfreqs, 1); % add jitter to x-axis locations
    circle_area = 7;
    scatter(X1, reshape(dfirst, [1 size(dfirst,1)*size(dfirst,2)]),circle_area,cud1);
    scatter(X2, reshape(dsecond, [1 size(dsecond,1)*size(dsecond,2)]),circle_area,cud2);
end
if want_boxplot
    boxplot(dfirst,'colors',cud1,'medianstyle','target','PlotStyle','compact','LabelOrientation','horizontal');
    boxplot(dsecond,'colors',cud2,'medianstyle','target','PlotStyle','compact','LabelOrientation','horizontal');
end
if want_errorbar
    errorbar(1:Nfreqs, y1, e_first, '+-', 'Color', cud1);
    errorbar(1:Nfreqs, y2, e_second, '+-', 'Color', cud2);
end

if want_scatter
    sigstar_plot_type = 'scatter';
elseif want_boxplot
    sigstar_plot_type = 'boxplot';
else
    sigstar_plot_type = 'errorbar';
end
ax=gca;
%sigstar(sigstar_plot_type,{[1,2], [3,4]}, [0.01, 0.04], struct('want_ticks',0));

% Find groups for sigstar.
[pvals,rm_anova_tbl] = phd_exc_stats_rm(first, second, mf, 0.05)

desired_pvals = [1e-3, 1e-2, 0.05];
target_pvals = zeros(1, length(dmf));
G={};
P=[];
for dp=1:length(desired_pvals);

    % get only the pvals for this target.
    start_idx = 0;
    end_idx = 0;

    if dp==1
        target_pvals = pvals(dmf) < desired_pvals(dp);
    else
        target_pvals = (pvals(dmf) < desired_pvals(dp)) - (pvals(dmf) < desired_pvals(dp-1));
    end

    target_pvals_idxs = find(target_pvals==1);
    for i=1:length(target_pvals_idxs)
        if end_idx==0 && start_idx==0
            start_idx = i;
        elseif end_idx==0 && (target_pvals_idxs(i)-target_pvals_idxs(i-1))==1
            % Not at end of group; keep going
            continue; 
        else

            % Then we can record the group. End is the previous i; current one is start
            % of new group.
            G{length(G)+1} = [target_pvals_idxs(start_idx), target_pvals_idxs(i-1)];
            P(length(G)) = desired_pvals(dp);
            start_idx = i;
            end_idx = 0;
        end
    end

    % Last one needs to be recorded, as well.
    if i
        G{length(G)+1} = [target_pvals_idxs(start_idx), target_pvals_idxs(i)];
        P(length(G)) = desired_pvals(dp);
    end
    clear start_idx, end_idx;
end

% DEBUG purposes
%{
G{:}
P
%}

% ONLY display stars if rmANOVA showed significant differences across groups
% {7,7} is Intercept:MF:HD by pValueHF
if rm_anova_tbl{7,7} < 0.05
    sigstar(sigstar_plot_type,G,P,struct('want_ticks',0,'FontSize',fontsize));
else
    G={[1 dmf(length(dmf))]};
    P=[1];
    sigstar(sigstar_plot_type,G,P,struct('want_ticks',0,'FontSize',fontsize));
end

% E.g. for VS_struct4.VS_hD0, VS_struct4.VS_hD1
%sigstar(sigstar_plot_type,{[1,2], [6], [8], [3], [5], [9]}, [1e-3, 1e-3, 1e-3, 1e-2, 0.05, 0.05], struct('want_ticks',0));

if isfield(props,'want_horizline')
    plot([1 Nfreqs], [1 1], 'k--'); % Horizontal line at Rnum=1
end

set(gca,'FontSize',fontsize);
set(gca,'XTick',1:Nfreqs);
xlabels = {'0.1', '0.5','1','2','3','4','5','8','9','10','12','15','16','20','25','30'};
set(gca,'XTickLabel',xlabels(dmf));
%set(gca,'XTickLabel',{'0.5','1','2','3','4','5','8','9','10','12','15','16','20','25','30'});
set(gca,'XTickLabelRotation',-45);
if isfield(props,'title_str')
    title(props.title_str);
end
if isfield(props,'custom_ylim')
    ylim(props.custom_ylim);
else
    axis 'auto y';
end
if isfield(props,'custom_ytick')
    set(gca,'YTick',props.custom_ytick);
end
if ~zoomed
    ylabel(meas_name);
    xlabel('Modulation frequencies (Hz)');
    if want_legend
        if isfield(props,'legend_orientation')
            legend_orientation=props.legend_orientation;
        else
            legend_orientation='horizontal';
        end
        legend(leg_names,'Location','best','Orientation',legend_orientation,'FontSize',12);
    end
end
set(gca,'box','off');
f.PaperUnits = 'inches';
if isfield(props,'PaperPosition')
    f.PaperPosition = props.PaperPosition;
else
    f.PaperPosition = [0 0 6 5];
end

if fileloc
%{
    if ~win
        filename = sprintf('rotn_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('rotn_win_%g_%s.png', desired_modulation, title_str);
    end
%}
    if ~isfield(props,'filename')
        disp(sprintf('ERROR: must provide filename'));
        return;
    end
    input('Press Enter to print.');
    filename = props.filename;
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dsvg');
end

end
