
function elife2016_plot_psds(model_path_A, model_path_B, fileloc, props)

[A_a_t, A_a_prof, A_pxx, A_f, A_V] = phd_exc_psd(model_path_A, 1, 1);
[B_a_t, B_a_prof, B_pxx, B_f, B_V] = phd_exc_psd(model_path_B, 1, 1);

cud;
cud1 = cud_black;
cud2 = cud_skyBlue;

f = figure;
loglog(A_f, A_pxx, 'Color',cud1);
hold on;
loglog(B_f, B_pxx, 'Color',cud2);
xlabel('Frequency (Hz)');
ylabel('Power (spikes^2/Hz)');
if isfield(props,'ylim')
disp('YEP')
    ylim(props.ylim);
end
if isfield(props,'XTick')
    set(gca,'XTick',props.XTick);
else
    %set(gca,'XTick',[8 16 24 32 40 60 80 100]);
    set(gca,'XTick',[2.5 8 16 30 100]);
end
%set(gca,'XTick',[0.5 5 8 10 16 20 32 40 50 60 70 80 90 100]);
set(gca,'box','off');
f.PaperUnits = 'inches';
f.PaperPosition = [0 0 6 4];

if fileloc
    if ~isfield(props,'filename')
        disp(sprintf('ERROR: must provide filename'));
        return;
    end
    input('Press Enter to print.');
    filename = sprintf('%s.svg', props.filename);
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dsvg');
end

f = figure;
loglog(A_f, A_pxx, 'Color',cud1);
hold on;
loglog(B_f, B_pxx, 'Color',cud2);
ylabel('Power (spikes^2/Hz)');
xlim([0 20]);
if isfield(props,'ylim')
    ylim(props.ylim);
end
if isfield(props,'zoomed_XTick')
    set(gca,'XTick',props.zoomed_XTick);
else
    set(gca,'XTick',[2.5 8 16]);
end
set(gca,'box','off');
f.PaperUnits = 'inches';
f.PaperPosition = [0 0 3 2];

if fileloc
    if ~isfield(props,'filename')
        disp(sprintf('ERROR: must provide filename'));
        return;
    end
    input('Press Enter to print (ZOOMED).');
    filename = sprintf('%s_zoomed.svg', props.filename);
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dsvg');
end

end
