%{

Subthreshold figure stuff. Plots last Vm values in period/2.

%}
function elife2016_plot_subth(end_Vms, scen, fileloc, props)

if nargin < 4
    props = struct();
end
if nargin < 3
    fileloc = '';
end

if isfield(props,'want_scatter')
    want_scatter=props.want_scatter;
else
    want_scatter=0;
end
if isfield(props,'want_boxplot')
    want_boxplot=props.want_boxplot;
else
    want_boxplot=0;
end
if isfield(props,'want_errorbar')
    want_errorbar=props.want_errorbar;
else
    want_errorbar=0;
end
if ~want_scatter && ~want_boxplot && ~want_errorbar
    disp(sprintf('ERROR: need one of want_scatter, want_boxplot, or want_errorbar.'));
    return;
end

cud; 
cud1 = cud_skyBlue;
cud2 = cud_black;
%{
cud1 = cud_skyBlue;
cud2 = cud_orange;
cud3 = cud_black;
%}

f=figure;
hold on;

if scen==4
    mod = end_Vms.mod4;
    blh = end_Vms.blh4;
    cAMP = end_Vms.cAMP4;
elseif scen==5
    mod = end_Vms.mod5;
    blh = end_Vms.blh5;
    cAMP = end_Vms.cAMP5;
else
    disp(sprintf('ERROR: invalid scen param'));
    return;
end

y_mod=nanmedian(mod);
y_blh=nanmedian(blh);
y_cAMP=nanmedian(cAMP);

std_mod=std(mod);
std_blh=std(blh);
std_cAMP=std(cAMP);

plot([y_mod y_blh y_cAMP],'-','LineWidth',1,'Color',cud_black);

X_mod = ones(1, length(mod));
X_blh = ones(1, length(blh))+1;
X_cAMP = ones(1, length(cAMP))+2;
if want_scatter
    circle_area = 7;
    scatter(X_mod, mod, circle_area, cud1)
    scatter(X_blh, blh, circle_area, cud1)
    scatter(X_cAMP, cAMP, circle_area, cud1)
end
if want_boxplot
%    boxplot([mod blh cAMP], [X_mod X_blh X_cAMP],'colorgroup',[repmat(cud1,length(X_mod),1); repmat(cud2,length(X_blh),1); repmat(cud3,length(X_cAMP),1)],'medianstyle','target');
    boxplot([mod blh cAMP], [X_mod X_blh X_cAMP],'Color',cud_black,'medianstyle','target');
end
if want_errorbar
    errorbar(1:Nfreqs, y1, e_first, '+-', 'Color', cud1);
    errorbar(1:Nfreqs, y2, e_second, '+-', 'Color', cud2);
end

if want_scatter
    sigstar_plot_type = 'scatter';
elseif want_boxplot
    sigstar_plot_type = 'boxplot';
else
    sigstar_plot_type = 'errorbar';
end
%}
ax=gca;
ax.DataAspectRatio = [1 2 1];

% Find groups for sigstar.
[stat_results1, pval1] = phd_exc_stats_subth(mod, blh, 0.01);
[stat_results2, pval2] = phd_exc_stats_subth(mod, cAMP, 0.01);
[stat_results3, pval3] = phd_exc_stats_subth(blh, cAMP, 0.01);

G = {[1 2], [1 3], [2 3]};
P = [pval1, pval2, pval3];
sigstar(sigstar_plot_type, G, P, struct('want_ticks',1));


%{
[stat_results, pvals] = phd_exc_stats(first, second, mf, 0.05);

desired_pvals = [1e-3, 1e-2, 0.05];
target_pvals = zeros(1, length(dmf));
G={};
P=[];
for dp=1:length(desired_pvals);

    % get only the pvals for this target.
    start_idx = 0;
    end_idx = 0;

    if dp==1
        target_pvals = pvals(dmf) < desired_pvals(dp);
    else
        target_pvals = (pvals(dmf) < desired_pvals(dp)) - (pvals(dmf) < desired_pvals(dp-1));
    end

    target_pvals_idxs = find(target_pvals==1);
    for i=1:length(target_pvals_idxs)
        if end_idx==0 && start_idx==0
            start_idx = i;
        elseif end_idx==0 && (target_pvals_idxs(i)-target_pvals_idxs(i-1))==1
            % Not at end of group; keep going
            continue; 
        else

            % Then we can record the group. End is the previous i; current one is start
            % of new group.
            G{length(G)+1} = [target_pvals_idxs(start_idx), target_pvals_idxs(i-1)];
            P(length(G)) = desired_pvals(dp);
            start_idx = i;
            end_idx = 0;
        end
    end

    % Last one needs to be recorded, as well.
    if i
        G{length(G)+1} = [target_pvals_idxs(start_idx), target_pvals_idxs(i)];
        P(length(G)) = desired_pvals(dp);
    end
    clear start_idx, end_idx;
end
%}

% DEBUG purposes
%{
G{:}
P
%}
%sigstar(sigstar_plot_type,G,P,struct('want_ticks',0));

% E.g. for VS_struct4.VS_hD0, VS_struct4.VS_hD1
%sigstar(sigstar_plot_type,{[1,2], [6], [8], [3], [5], [9]}, [1e-3, 1e-3, 1e-3, 1e-2, 0.05, 0.05], struct('want_ticks',0));

%{
if isfield(props,'want_horizline')
    plot([1 Nfreqs], [1 1], 'k--'); % Horizontal line at Rnum=1
end
%}

%legend({sprintf('ctl %g', y_mod), sprintf('-H %g', y_blh), sprintf('+cAMP %g', y_cAMP)});
set(gca,'FontSize',16);
set(gca,'XTick',1:3);
set(gca,'XTickLabel',{'ctl','-H','+cAMP'});
set(gca,'XTickLabelRotation',-45);
if isfield(props,'title_str')
    title(props.title_str);
end
if isfield(props,'custom_ylim')
    ylim(props.custom_ylim);
else
    axis 'auto y';
end
ylabel('V_m (mV');
%xlabel('Conditions');

if fileloc
%{
    if ~win
        filename = sprintf('rotn_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('rotn_win_%g_%s.png', desired_modulation, title_str);
    end
%}
    if ~isfield(props,'filename')
        disp(sprintf('ERROR: must provide filename'));
        return;
    end
    input('Press Enter to print.');
    filename = props.filename;
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end
end
