% [timeidx, peakval, n] = findspikes_old(trace, t, threshold, plotit)
% 
% Find and return: spike times (timeidx), spike peak amplitude (peakval) 
% and number of spikes (n) in the given trace above the given threshold.
% If plotit is 1, a figure is displayed for visual inspection.
% 
% NOTE: Only positive (up stroke) spike peaks are treated and are found
%       on the basis of a "three-point first derivative evaluation".
% 
% Author: <adelgado@biology.emory.edu>, 2003-03-31

% Copyright (c) 2007 Cengiz Gunay <cengique@users.sf.net>.
% This work is licensed under the Academic Free License ("AFL")
% v. 3.0. To view a copy of this license, please look at the COPYING
% file distributed with this software or visit
% http://opensource.org/licenses/afl-3.0.php.

%
% Modified by Vladislav Sekulic, July 31, 2015, to work with NEURON simulation
% outputs generated by variable timestep (CVODE) integration.
%

function [timeidx, peakval, n] = findspikes_old(trace, t, thres, plotit)
    
    peakst = find(trace >= thres);
    
    peaksv = ones(size(trace)).*thres;
    
    peaksv(peakst) = trace(peakst);
    
    peaksdy = diff(peaksv)';
    
    % post-process peaksdy so that dy=0 points are removed, since this then prevents 
    % certain spikes from not being detected. So, just replace dy=0 points with the 
    % previous data point value (or next one, if at the beginning of peaksdy).
    for i=1:length(peaksdy)
        if peaksdy(i) == 0
            if i == 1
                peaksdy(i) = peaksdy(i+1);
            else
                peaksdy(i) = peaksdy(i-1);
            end
        end
    end
    timeidx = find(([peaksdy 0] < 0) & ([0 peaksdy] > 0));
    
    if plotit == 1
      figure
      plot(t, trace,  'k'), hold on
      plot(t, peaksv, 'b');
      plot(t(timeidx), peaksv(timeidx), 'ro');
    end
    
    if nargout > 1
        peakval = peaksv(timeidx)';
        [m, n]  = size(peakval);
    end
    
    clear m peaks*;
end
