%{

%}
function [bintimes, grand_psth, grand_psth_blh, models, models_blh] = get_psth_models(models, models_blh, freq, desired_mo, to_fit, plotting, verbose, fileloc)
    if nargin < 8
        fileloc = '';
    end
    if nargin < 7
        verbose = 0;
    end
    if nargin < 6
        plotting = 0;
    end
    if nargin < 5
        to_fit = 0;
    end
    if nargin < 4
        desired_mo = 0.4;
    end

    period = 1e3/freq;

    phd_exc_load_mod;
    mo_idx = find(mo == desired_mo);
    mf_idx = find(mf == freq);

    grand_psth = [];
    grand_psth_blh = [];
    i_tot = 0;
    j_tot = 0;
    bintimes = [];
    for i=1:length(models)
        if verbose
            disp(sprintf('Processing rank %d at %g Hz with %g mo...', models(i).rank, freq, mo(mo_idx)));
        end
        j = find([models_blh.rank] == models(i).rank);
        if isempty(j) && verbose
            disp(sprintf('*** ERROR at models idx %d: models_blh does not have rank %d (but models does)!', i, models(i).rank));
            disp(sprintf('*** Skipping this rank in models_blh for now...'));
        end 

        spike_struct = models(i).mod.mo(mo_idx).mf(mf_idx).psd.rel.spike;
        x = spike_struct.x;
        yt = spike_struct.yt;
        psth_struct = calc_psth(x, yt, freq, 0);
        psth = psth_struct.psth;
        psth_norm = psth ./ sum(psth);

        psth_struct.psth_norm = psth_norm;
        diffs = psth_struct.diffs;
        [VS, R] = vector_strength(diffs, period);
        psth_struct.VS = VS;
        psth_struct.R = R;
        models(i).mod.mo(mo_idx).mf(mf_idx).psd.rel.psth = psth_struct;

        %psth = models(i).mod.mo(mo_idx).mf(mf_idx).psd.rel.psth;
        grand_psth = [grand_psth diffs];
%{
        if ~isempty(grand_psth)
            %grand_psth = grand_psth + psth_struct.psth;
            grand_psth = grand_psth + psth_norm;
        else
            %grand_psth = psth_struct.psth;
            grand_psth = psth_norm;
        end
%}
        i_tot = i_tot + 1;
        if isempty(bintimes)
            bintimes = psth_struct.bintimes;
        end

%{
        if plotting
            if to_fit
                datafit = fit(bintimes', psth', 'gauss1');
                f = figure;
                set(gca,'FontSize',16);
                plot(datafit,bintimes,psth,'*');
                xlabel('Post-stimulus bins (ms)');
                ylabel('Spike count');
                title(sprintf('PSTH and single Gaussian fit (rank %d mo %g mf %g)', models(i).rank, desired_mo, freq));

                if fileloc
                    filename = sprintf('psth_rank%d_fit_mo_%g_mf_%g_%s.png', models(i).rank, desired_mo, freq);
                    disp(sprintf('PRINTING to file %s', filename));
                    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
                end
            end

            f = figure;
            set(gca,'FontSize',16);
            %bar(bintimes,psth);
            h1 = histogram(psth_struct.diffs,'Normalization','probability');
            xlabel('Post-stimulus bins (ms)');
            %ylabel('Spike count');
            ylabel('Spike probability');
            title(sprintf('PSTH histogram (rank %d mo %g mf %g)', models(i).rank, desired_mo, freq));
            if fileloc
                filename = sprintf('psth_rank%d_hist_mo_%g_mf_%g_%s.png', models(i).rank, desired_mo, freq);
                disp(sprintf('PRINTING to file %s', filename));
                print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
            end
        end
%}

        if j
            spike_struct = models_blh(j).mod.mo(mo_idx).mf(mf_idx).psd.rel.spike;
            x = spike_struct.x;
            yt = spike_struct.yt;
            psth_struct = calc_psth(x, yt, freq, 0);
            psth = psth_struct.psth;
            psth_norm = psth ./ sum(psth);

            psth_struct.psth_norm = psth_norm;
            diffs_blh = psth_struct.diffs;
            [VS, R] = vector_strength(diffs_blh, period);
            psth_struct.VS = VS;
            psth_struct.R = R;
            models_blh(j).mod.mo(mo_idx).mf(mf_idx).psd.rel.psth = psth_struct;

            %psth_blh = models_blh(j).mod.mo(mo_idx).mf(mf_idx).psd.rel.psth;
            grand_psth_blh = [grand_psth_blh diffs_blh];

%{
            if ~isempty(grand_psth_blh)
                %grand_psth_blh = grand_psth_blh + psth_struct.psth;
                grand_psth_blh = grand_psth_blh + psth_norm;
            else
                %grand_psth_blh = psth_struct.psth;
                grand_psth_blh = psth_norm;
            end
%}
            j_tot = j_tot + 1;
            if plotting
                if to_fit
                    datafit = fit(bintimes', psth', 'gauss1');
                    f = figure;
                    set(gca,'FontSize',16);
                    plot(datafit,bintimes,psth,'*');
                    xlabel('Post-stimulus bins (ms)');
                    ylabel('Spike count');
                    title(sprintf('PSTH and single Gaussian fit (rank %d mo %g mf %g) BLH', models(i).rank, desired_mo, freq));

                    if fileloc
                        filename = sprintf('psth_rank%d_blh_fit_mo_%g_mf_%g_%s.png', models(i).rank, desired_mo, freq);
                        disp(sprintf('PRINTING to file %s', filename));
                        print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
                    end
                end

                f = figure;
                set(gca,'FontSize',16);
                %bar(bintimes,psth);
                h1 = histogram(diffs,'Normalization','probability');
                hold on;
                h2 = histogram(diffs_blh,'Normalization','probability');
                legend('ctl','blh');
                xlabel('Post-stimulus bins (ms)');
                %ylabel('Spike count');
                ylabel('Spike probability');
                %title(sprintf('PSTH histogram (rank %d mo %g mf %g) BLH', models(i).rank, desired_mo, freq));
                title(sprintf('PSTH histogram (rank %d mo %g mf %g)', models(i).rank, desired_mo, freq));
                if fileloc
                    %filename = sprintf('psth_rank%d_blh_hist_mo_%g_mf_%g_%s.png', models(i).rank, desired_mo, freq);
                    filename = sprintf('psth_rank%d_hist_mo_%g_mf_%g.png', models(i).rank, desired_mo, freq);
                    disp(sprintf('PRINTING to file %s', filename));
                    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
                end
            end
        end

    end    

    if verbose
        disp(sprintf('*** Normalizing grand_psth for models (%d total) and models_blh (%d total)...', i_tot, j_tot));
    end
%    grand_psth = grand_psth ./ i_tot ./ 5
%    grand_psth_blh = grand_psth_blh ./ j_tot;
end
