%{

  Inputs:
    models - struct array returned by phd_exc_load_sets.m
    desired_freq - a number corresponding to the desired frequency for the power ratio calculation

  Outputs: 
    Will plot the power ratio plots for the frequency ranges that exist in the models struct.

  Example:
    phd_exc_pratio(models, 8);

%}
function qv_models = phd_exc_Qval(models, desired_freq, desired_modulation, title_str, plotit)
%disp(sprintf('desired_freq %g desired_modulation %g', desired_freq, desired_modulation));

% plot by default!
if nargin < 4
    plotit = 1;
end
phd_exc_load_mod % to get mo and mf

qv_models = [];
df = desired_freq;

%%%%%%%%%%%%%%%%%%%%%%%%
% SCENARIO 4 - soma only
%%%%%%%%%%%%%%%%%%%%%%%%

for i=1:length(models)

    % Calculate power ratio at desired frequency for no modulation traces
    psd_nomod = models(i).nomod.psd;
    idx_dHz = find(psd_nomod.f == df);
    idx_05Hz = find(psd_nomod.f == 0.5);
    pr_p = psd_nomod.pxx(idx_dHz) / psd_nomod.pxx(idx_05Hz);
    if isnan(pr_p)
        pr_p = 0;
    end
    %models(i).nomod.psd.pr_p = pr_p;
    qv_models(i, 1) = pr_p;

    % Find the mo first
    mo_idx = find(mo == desired_modulation);
%{
    mo_idx = 0;
    for k=1:length(models(i).mod.mo)
        if models(i).mod.mo(k).mo == desired_modulation
            mo_idx = k;
        end
    end
%}

    if isempty(models(i).mod)
        continue;
    end

    % Now for the power ratio of the modulated frequencies, at the desired modulation amount
    for mo_idx=1:length(models(i).mod.mo)
    for j=1:length(models(i).mod.mo(mo_idx).mf)
        psd_mod = models(i).mod.mo(mo_idx).mf(j).psd;
        if isempty(psd_mod) % to deal with cancelled jobs...
            qv_models(i, j+1) = NaN;
            disp(sprintf('models(%d) rank %d mf %d has missing psd, REMOVED', i, models(i).rank, j));
            continue;
        end
        if psd_mod.a_prof.n < 6
            disp(sprintf('models(%d) rank %d mf %d has <= 5 spikes, REMOVED', i, models(i).rank, j));
            pr_p = NaN;
        else
            idx_dHz = find(psd_mod.f == df);
            idx_05Hz = find(psd_mod.f == 0.5);
            pr_p = psd_mod.pxx(idx_dHz) / psd_mod.pxx(idx_05Hz);

            % Some models have missing PSDs, so exclude them entirely from subsequent statistics.
            if pr_p == 0
                disp(sprintf('models(%d) rank %d mf %d has 0 Qval but PSD NOT empty, why? REMOVED anyway', i, models(i).rank, j));
                pr_p = NaN;
            end
        end
        %models(i).mod.mo(mo_idx).mf(j).pr_p = pr_p;

        % Group power ratio for all modulation frequencies of all models together
        qv_models(i, j+1) = pr_p;
    end
    end
end

% Sanitize qv_models via two steps:
% 1. Set all NaN values to zeros;
% 2. Set all pr_ratio values close to 1 to zero
%qv_models(isnan(qv_models)) = 0;
%{
for i=1:size(qv_models,1)
    for j=1:size(qv_models,2)
        if qv_models(i,j) >= 1-1e-09
            disp(sprintf('    i %d j %d removed as pr_ratio close to 1', i,j));
            qv_models(i,j) = NaN;
        end
    end
end
%}
            
if plotit
    figure;
    if length(models) > 1
        boxplot(qv_models);
    else
        bar(qv_models);
    end
    set(gca,'XTickLabel',[0 mf]);
    title(sprintf('Q-values at %gHz power - %s', df, title_str));
%    ylim([0:1]);
    ylabel(sprintf('Ratio of %gHz power to 0.5 frequency power', df));
end

end
