%{

VS plots.

If 'win' is set to 1, then only a window of fixed cycles for each frequency is considered.

Will plot resulting response and error rate plots.

%}
function [VS_models] = phd_exc_VS_plots(models, desired_modulation, title_str, win, fileloc)

if nargin < 5
    fileloc='';
end

VS_models = [];
phd_exc_load_mod; % to get mo and mf
mo_idx = find(mo == desired_modulation);

for rank=1:length(models)
 
    for j=1:length(mf)
        psd = models(rank).mod.mo(mo_idx).mf(j).psd;
        if isempty(psd)
            VS_models(rank,j) = NaN;
            continue;
        end
        if ~win
            VS_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.psth.VS;
        else
            VS_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.psth.VS_win;
        end
    end
end
            
X = phd_exc_load_plotting(length(models), size(VS_models,2));
f=figure;
hold on;
if length(models) > 1
    scatter(X, reshape(VS_models, [1 size(VS_models,1)*size(VS_models,2)]),15,'k');
    boxplot(VS_models);
else
    bar(VS_models);
end
set(gca,'FontSize',16);
set(gca,'XTickLabel',mf);
set(gca,'XTickLabelRotation',-45);
title(sprintf('%s', title_str),'FontSize',16);
ylim([0:1]);
%ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));
ylabel('Vector strength');
xlabel('Modulation frequencies (Hz)');

if fileloc
    if ~win
        filename = sprintf('VS_mo_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('VS_win_%g_%s.png', desired_modulation, title_str);
    end
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

end
