%{

'Default' invocation:

VS_struct = phd_exc_anal_VS(models, models_blh, 0.4, 0, '');

And for saving plots to disk:

VS_struct = phd_exc_anal_VS(models, models_blh, 0.4, 0, '~/research/project/img/VS');

%}
function [VS_struct] = phd_exc_anal_VS(models, models_blh, desired_mo, win, fileloc)
    if nargin < 5
        fileloc = '';
    end

    [hD0_ranks, hD1_ranks] = phd_exc_load_models_to_ranks(models);
    [hD0_ranks_blh, hD1_ranks_blh ] = phd_exc_load_models_to_ranks(models_blh);

    pause('on');
    VS_hD0 = phd_exc_VS_plots(models(hD0_ranks), desired_mo, sprintf('Somatic I_h models'), win, fileloc);
    pause(1);
    VS_hD1 = phd_exc_VS_plots(models(hD1_ranks), desired_mo, sprintf('Somatodendritic I_h models'), win, fileloc);
    pause(1);
    VS_hD0_blh = phd_exc_VS_plots(models_blh(hD0_ranks_blh), desired_mo, sprintf('Somatic I_h models, I_h blocked'), win, fileloc);
    pause(1);
    VS_hD1_blh = phd_exc_VS_plots(models_blh(hD1_ranks_blh), desired_mo, sprintf('Somatodendritic I_h models, I_h blocked'), win, fileloc);
    pause(1);
    pause('off');

%{
    phd_exc_load_mod;
    dfs = ismember(mf, desired_modfreqs);
    mf_8Hz = find(mf==8);
%}

    VS_struct.VS_hD0 = VS_hD0;
    VS_struct.VS_hD1 = VS_hD1;
    VS_struct.VS_hD0_blh = VS_hD0_blh;
    VS_struct.VS_hD1_blh = VS_hD1_blh;
end
