function [rotn_struct] = phd_exc_anal_rotn(models, models_blh, desired_mo, desired_modfreqs, win, fileloc)
    if nargin < 6
        fileloc = '';
    end
    [hD0_ranks, hD1_ranks ] = phd_exc_load_models_to_ranks(models);
    [hD0_ranks_blh, hD1_ranks_blh] = phd_exc_load_models_to_ranks(models_blh);

    % Must pause between each plot since otherwise they're aren't constructed properly.
    pause('on');
    rotn_hD0 = phd_exc_rotn_plots(models(hD0_ranks), desired_mo, desired_modfreqs, sprintf('Somatic I_h models'), win, fileloc);
    pause(1);
    rotn_hD1 = phd_exc_rotn_plots(models(hD1_ranks), desired_mo, desired_modfreqs, sprintf('Somatodendritic I_h models'), win, fileloc);
    pause(1);
    rotn_hD0_blh = phd_exc_rotn_plots(models_blh(hD0_ranks_blh), desired_mo, desired_modfreqs, sprintf('Somatic I_h models, I_h blocked'), win, fileloc);
    pause(1);
    rotn_hD1_blh = phd_exc_rotn_plots(models_blh(hD1_ranks_blh), desired_mo, desired_modfreqs, sprintf('Somatodendritic I_h models, I_h blocked'), win, fileloc);
    pause(1);
    pause('off');

    phd_exc_load_mod;
    dfs = ismember(mf, desired_modfreqs);
    mf_8Hz = find(mf==8);

    rotn_struct.rotn_hD0 = rotn_hD0;
    rotn_struct.rotn_hD1 = rotn_hD1;
    rotn_struct.rotn_hD0_blh = rotn_hD0_blh;
    rotn_struct.rotn_hD1_blh = rotn_hD1_blh;
end
