function [rr_struct, er_struct] = phd_exc_anal_rr(models, models_blh, scen, desired_mo, desired_modfreqs, win, fileloc)
    if nargin < 7
        fileloc = '';
    end
    [hD0_ranks, hD1_ranks ] = phd_exc_load_models_to_ranks(models);
    [hD0_ranks_blh, hD1_ranks_blh] = phd_exc_load_models_to_ranks(models_blh);

    % Must pause between each plot since otherwise they're aren't constructed properly.
    pause('on');
    [rr_hD0, er_hD0] = phd_exc_rrate_plots(models(hD0_ranks), desired_mo, sprintf('Somatic I_h models'), win, fileloc);
    pause(1);
    [rr_hD1, er_hD1] = phd_exc_rrate_plots(models(hD1_ranks), desired_mo, sprintf('Somatodendritic I_h models'), win, fileloc);
    pause(1);
    [rr_hD0_blh, er_hD0_blh] = phd_exc_rrate_plots(models_blh(hD0_ranks_blh), desired_mo, sprintf('Somatic I_h models, I_h blocked'), win, fileloc);
    pause(1);
    [rr_hD1_blh, er_hD1_blh] = phd_exc_rrate_plots(models_blh(hD1_ranks_blh), desired_mo, sprintf('Somatodendritic I_h models, I_h blocked'), win, fileloc);
    pause(1);
    pause('off');

    phd_exc_load_mod;
    dfs = ismember(mf, desired_modfreqs);
    mf_8Hz = find(mf==8);

%    pr_8Hz_hD0 = [pr_nat_hD0(:,1) pr_nat_hD0_blh(:,1) pr_nat_hD0(:,mf_8Hz+1) pr_nat_hD0_blh(:,mf_8Hz+1)];
%    pr_8Hz_hD1 = [pr_nat_hD1(:,1) pr_nat_hD1_blh(:,1) pr_nat_hD1(:,mf_8Hz+1) pr_nat_hD1_blh(:,mf_8Hz+1)];

%    f = phd_exc_plot_pratio_8Hz(pr_8Hz_hD0, 'Somatic I_h models', scen, desired_mo);
%    f = phd_exc_plot_pratio_8Hz(pr_8Hz_hD1, 'Somatodendritic I_h models', scen, desired_mo);

    rr_struct.rr_hD0 = rr_hD0;
    rr_struct.rr_hD1 = rr_hD1;
    rr_struct.rr_hD0_blh = rr_hD0_blh;
    rr_struct.rr_hD1_blh = rr_hD1_blh;

    er_struct.er_hD0 = er_hD0;
    er_struct.er_hD1 = er_hD1;
    er_struct.er_hD0_blh = er_hD0_blh;
    er_struct.er_hD1_blh = er_hD1_blh;
%    pr_struct.pr_8Hz_hD0 = pr_8Hz_hD0;
%    pr_struct.pr_8Hz_hD1 = pr_8Hz_hD1;
end
