
function spikerates = phd_exc_anal_spikerates(models, desired_mo, plotit, titlestr)

    if nargin < 4
        titlestr = '';
    end
    if nargin < 3
        plotit = 0;
    end

    phd_exc_load_mod;

    if desired_mo == 0.2
        mo_idx = 1;
    elseif desired_mo == 0.4
        mo_idx = 2;
    elseif desired_mo == 0.6
        mo_idx = 3;
    end


    for i=1:length(models)

        % Do nomod first
        spikerates(i, 1) = models(i).nomod.psd.a_prof.n / 60;

        mod = models(i).mod;
        if isempty(mod)
            continue;
        end
        for j=1:length(models(i).mod.mo(mo_idx).mf)
            psd_mod = models(i).mod.mo(mo_idx).mf(j).psd;
            if isempty(psd_mod)
                continue;
            end
            spikerates(i, j+1) = psd_mod.a_prof.n / 30;
        end
    end

    if plotit
        f=figure;
        X = getX(size(spikerates, 1), size(spikerates, 2));
        hold on;
    disp(size(X))
        scatter(X, reshape(spikerates, [1 size(spikerates,1)*size(spikerates,2)]));
        boxplot(spikerates);
        set(gca,'XTickLabel',[0 mf]);
        ylabel('Firing rates (Hz)');
        title(sprintf('Spike rates as a function of modulation frequency %s', titlestr));
    end
end
