%{

Plots angular means for models across desired modulation frequencies.

If 'win' is set to 1, then only a window of fixed cycles for each frequency is considered.

Will plot resulting response and error rate plots.

%}
function [am_models] = phd_exc_angmean_plots(models, desired_modulation, title_str, win, fileloc)

if nargin < 5
    fileloc='';
end

am_models = [];
phd_exc_load_mod; % to get mo and mf
mo_idx = find(mo == desired_modulation);

for rank=1:length(models)
 
    for j=1:length(mf)
        psd = models(rank).mod.mo(mo_idx).mf(j).psd;
        if isempty(psd)
            am_models(rank,j) = NaN;
            continue;
        end

        period = 1e3/mf(j);
        if ~win
            am_models(rank,j) = angmean(models(rank).mod.mo(mo_idx).mf(j).psd.rel.psth.diffs,period);
        else
            am_models(rank,j) = 0;
        end
    end
end
            
X = phd_exc_load_plotting(length(models), size(am_models,2));
f=figure;
hold on;
if length(models) > 1
    scatter(X, reshape(am_models, [1 size(am_models,1)*size(am_models,2)]),15,'k');
    boxplot(am_models);
else
    bar(am_models);
end
set(gca,'FontSize',16);
set(gca,'XTickLabel',mf);
set(gca,'XTickLabelRotation',-45);
title(sprintf('%s', title_str),'FontSize',16);
ylim([0 (2*pi)]);
%ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));
ylabel('Angular mean');
xlabel('Modulation frequencies (Hz)');

if fileloc
    if ~win
        filename = sprintf('am_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('am_win_%g_%s.png', desired_modulation, title_str);
    end
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

end
