
topdir = '~/bigdata/scinet/scratch/O-LM_runs/phd_exc';
prefix_str = {'scen4_cAMP2_1'};
desired_mo = 0.4;
MAT_fileprefix = sprintf('scen4_cAMP2_mo_%g', desired_mo);
MAT_dir = '~/research/project/MAT_files';

[models] = phd_exc_load_sets(topdir, prefix_str, desired_mo);
[hD0_ranks, hD1_ranks] = phd_exc_load_models_to_ranks(models);
disp(sprintf('SAVING...'));
save(sprintf('%s/%s.mat', MAT_dir, MAT_fileprefix),'-v7.3');

%{
fileloc = '~/Dropbox/research/project/img/psl_annrep2016/cAMP2'

scen4_cAMP_blh = load('scen4_cAMP_blh_mo_0.4.mat');
hD0_ranks4_cAMP_blh=scen4_cAMP_blh.hD0_ranks;
hD1_ranks4_cAMP_blh=scen4_cAMP_blh.hD1_ranks;
pr_struct4_cAMP2 = phd_exc_anal_pratio(models4_cAMP2, models4_cAMP_blh, desired_mo, mf)
rotn_struct4_cAMP2 = phd_exc_anal_rotn(models4_cAMP2, models4_cAMP_blh, 0.4, mf(~ismember(mf,[0.1 0.5])), 0, '');
VS_struct4_cAMP2 = phd_exc_anal_VS(models4_cAMP2, models4_cAMP_blh, 0.4, 0, fileloc)
am_struct4_cAMP2 = phd_exc_anal_angmean(models4_cAMP2, models4_cAMP_blh, 0.4, 0, fileloc);



%%%%%%% S %%%%%%%%%
% Fig. 5Ei
elife2016_plot_measure(pr_struct4_cAMP.pr_nat_hD0, pr_struct4_cAMP2.pr_nat_hD0, {'H_{S} -H' 'H_{S} +cAMP2'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','pr_HS_blh_HS_cAMP2.png'));
% Fig. 5Eii
elife2016_plot_measure(rotn_struct4_cAMP.rotn_hD0, rotn_struct4_cAMP.rotn_hD0, {'H_{S}' 'H_{S} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig5Eii.png'));
% Fig. 5Eiii
elife2016_plot_measure(pr_struct4.pr_nat_hD1, pr_struct4_cAMP.pr_nat_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Power ratio', fileloc, struct('want_scatter',0,'want_boxplot',1,'filename','Fig5Eiii.png'));
% Fig. 5Eiv
elife2016_plot_measure(rotn_struct4.rotn_hD1, rotn_struct4_cAMP.rotn_hD1, {'H_{SD}' 'H_{SD} +cAMP'}, 'Rotation number', fileloc, struct('want_scatter',0,'want_boxplot',1,'want_horizline',1,'filename','Fig5Eiv.png'));



props = struct('pratio',1);
phd_exc_pratio_nat(models(hD0_ranks), desired_mo, sprintf('pratio scen4 cAMP Ih hD0 mo %g', desired_mo), props, fileloc);
phd_exc_pratio_nat(models(hD1_ranks), desired_mo, sprintf('pratio scen4 cAMP Ih hD1 mo %g', desired_mo), props, fileloc);

fileloc = '~/Dropbox/research/project/img/pr_nat/cAMP/scen4'
props = struct('pratio',0);
phd_exc_pratio_nat(models(hD0_ranks), desired_mo, sprintf('power scen4 cAMP Ih hD0 mo %g', desired_mo), props, fileloc);
phd_exc_pratio_nat(models(hD1_ranks), desired_mo, sprintf('power scen4 cAMP Ih hD1 mo %g', desired_mo), props, fileloc);

save(sprintf('%s/%s.mat', MAT_dir, MAT_fileprefix),'-v7.3');
%}
