
topdir = '~/bigdata/scinet/scratch/O-LM_runs/phd_exc';
prefix_str = {'scen4_cAMP_1'};
desired_mo = 0.4;
MAT_fileprefix = sprintf('scen4_cAMP_mo_%g', desired_mo);
MAT_dir = '~/research/project/MAT_files';

[models] = phd_exc_load_sets(topdir, prefix_str, desired_mo);
[hD0_ranks, hD1_ranks] = phd_exc_load_models_to_ranks(models);
    
fileloc = '~/Dropbox/research/project/img/pratio_nat/cAMP/scen4'
props = struct('pratio',1);
phd_exc_pratio_nat(models(hD0_ranks), desired_mo, sprintf('pratio scen4 cAMP Ih hD0 mo %g', desired_mo), props, fileloc);
phd_exc_pratio_nat(models(hD1_ranks), desired_mo, sprintf('pratio scen4 cAMP Ih hD1 mo %g', desired_mo), props, fileloc);

fileloc = '~/Dropbox/research/project/img/pr_nat/cAMP/scen4'
props = struct('pratio',0);
phd_exc_pratio_nat(models(hD0_ranks), desired_mo, sprintf('power scen4 cAMP Ih hD0 mo %g', desired_mo), props, fileloc);
phd_exc_pratio_nat(models(hD1_ranks), desired_mo, sprintf('power scen4 cAMP Ih hD1 mo %g', desired_mo), props, fileloc);

disp(sprintf('SAVING...'));
save(sprintf('%s/%s.mat', MAT_dir, MAT_fileprefix),'-v7.3');
