
function models_new = phd_exc_clean_models(models)

    for i=1:length(models)
        disp(sprintf('* Cleaning models i %d rank %d', i, models(i).rank));

        if isfield(models(i).nomod.psd,'V')
            models(i).nomod.psd = rmfield(models(i).nomod.psd,'V');
            disp(sprintf('  - cleaned nomod.psd'));
        else
            disp(sprintf('  - nomod.psd HAS NO V; skipping...'));
        end

        for j=1:length(models(i).mod.mo)
            if isempty(models(i).mod.mo(j))
                disp(sprintf('  * mo j %d does not exist; skipping...', j));
                continue;
            end

            disp(sprintf('  - cleaning mo j %d:', j));
            for k=1:length(models(i).mod.mo(j).mf)

                if isfield(models(i).mod.mo(j).mf(k).psd, 'V')
                    models(i).mod.mo(j).mf(k).psd = rmfield(models(i).mod.mo(j).mf(k).psd, 'V');
                    disp(sprintf('    - cleaned mf %d', k));
                else
                    disp(sprintf('    - mf(%d).psd HAS NO V; skipping...', k));
                end
            end
        end
    end
    models_new = models;
end
