
function phd_exc_dt_runs_comparison()

  cd ~/research/project/2006-RichyandStarfish-dendIh/dt_runs/

  [t_f1, V_f1] = load_trace('fixed_dt_0.0001.dat');
%  [t_f2, V_f2] = load_trace('fixed_dt_0.0005.dat');
  [t_f3, V_f3] = load_trace('fixed_dt_0.001.dat');
%  [t_f4, V_f4] = load_trace('fixed_dt_0.005.dat');
%  [t_f5, V_f5] = load_trace('fixed_dt_0.01.dat');
%  [t_f6, V_f6] = load_trace('fixed_dt_0.05.dat');

  [t_v1, V_v1] = load_trace('cvode_atol_1e-07.dat');
%  [t_v2, V_v2] = load_trace('cvode_atol_5e-07.dat');
%  [t_v3, V_v3] = load_trace('cvode_atol_1e-06.dat');
%  [t_v4, V_v4] = load_trace('cvode_atol_5e-06.dat');
%  [t_v5, V_v5] = load_trace('cvode_atol_1e-05.dat');
  [t_v6, V_v6] = load_trace('cvode_atol_5e-05.dat');
%  [t_v7, V_v7] = load_trace('cvode_atol_0.0001.dat');
%  [t_v8, V_v8] = load_trace('cvode_atol_0.0005.dat');
%  [t_v9, V_v9] = load_trace('cvode_atol_0.001.dat');
  [t_v10, V_v10] = load_trace('cvode_atol_0.005.dat');
%  [t_v11, V_v11] = load_trace('cvode_atol_0.01.dat');
%  [t_v12, V_v12] = load_trace('cvode_atol_0.05.dat');

  legend_str = {'dt=0.0001', 'dt=0.001', 'atol=1e-07', 'atol=5e-05', 'atol=0.005'};
  figure; hold on;

  plot(V_f1, gradient(V_f1, 0.0001), 'b-');
  plot(V_f3, gradient(V_f3, 0.001), 'b--');

  plot(V_v1, derivative(t_v1, V_v1), 'r-');
  plot(V_v6, derivative(t_v6, V_v6), 'r--');
  plot(V_v10, derivative(t_v10, V_v10), 'k-');

  set(gca,'FontSize',14);
  xlabel('V (mV)');
  ylabel('dV/dt (mV/ms)');
  legend(legend_str);

  figure; hold on;
  plot(t_f1, V_f1, 'b-');
  plot(t_f3, V_f3, 'b--');

  plot(t_v1, V_v1, 'r-');
  plot(t_v6, V_v6, 'r--');
  plot(t_v10, V_v10, 'k-');

  set(gca,'FontSize',14);
  xlabel('t (ms)');
  ylabel('V_m (mV)');
  legend(legend_str);

end

function [t, V] = load_trace(name)
  A = dlmread(name);
  t = A(:,1);
  V = A(:,2);
end

function g = derivative(t, V)

  for i=1:length(V)
    if i == 1
      d = V(2) - V(1);
      dt = t(2) - t(1);
    elseif i == length(V)
      d = V(i) - V(i-1);
      dt = t(i) - t(i-1);
    else
      d = V(i+1) - V(i-1);
      dt = t(i+1) - t(i-1);
    end
    g(i) = d / dt;
  end
end
