
cd ~/research/project/2006-RichyandStarfish-dendIh/dt_runs/
[t_long1, V_long1] = load_trace('longrun_atol_1e-06.dat');
[t_long2, V_long2] = load_trace('longrun_atol_1e-05.dat');

figure; hold on;
plot(t_long1, V_long1);
plot(t_long2, V_long2);

set(gca,'FontSize',14);
title('Longer simulations to differentiate CVODE 1e-06 and 1e-05 atol values');
xlabel('t (ms)');
ylabel('V (mV)');
legend({'atol=1e-06', 'atol=1e-05'});



lspec = {'k-', 'k--', 'b-', 'b--', 'r-', 'r--', 'g-', 'g--', 'c-', 'c--', 'm-', 'm--'};
[t1, V1] = load_trace('nosyn_atol_1e-07.dat');
[t2, V2] = load_trace('nosyn_atol_5e-07.dat');
[t3, V3] = load_trace('nosyn_atol_1e-06.dat');
[t4, V4] = load_trace('nosyn_atol_5e-06.dat');
[t5, V5] = load_trace('nosyn_atol_1e-05.dat');
[t6, V6] = load_trace('nosyn_atol_5e-05.dat');
[t7, V7] = load_trace('nosyn_atol_0.0001.dat');
[t8, V8] = load_trace('nosyn_atol_0.0005.dat');
[t9, V9] = load_trace('nosyn_atol_0.001.dat');
[t10, V10] = load_trace('nosyn_atol_0.005.dat');
[t11, V11] = load_trace('nosyn_atol_0.01.dat');
[t12, V12] = load_trace('nosyn_atol_0.05.dat');
legend_str = {'atol=1e-07', 'atol=5e-07', 'atol=1e-06', 'atol=5e-06', 'atol=1e-05', 'atol=5e-05', 'atol=0.0001', 'atol=0.0005', 'atol=0.001', 'atol=0.005', 'atol=0.01', 'atol=0.05'};

figure; hold on;
plot(t1, V1, lspec{1});
plot(t2, V2, lspec{2});
plot(t3, V3, lspec{3});
plot(t4, V4, lspec{4});
plot(t5, V5, lspec{5});
plot(t6, V6, lspec{6});
plot(t7, V7, lspec{7});
plot(t8, V8, lspec{8});
plot(t9, V9, lspec{9});
plot(t10, V10, lspec{10});
plot(t11, V11, lspec{11});
plot(t12, V12, lspec{12});

set(gca,'FontSize',14);
title('No synaptic inputs');
xlabel('t (ms)');
ylabel('V_m (mV)');
legend(legend_str);
