
function phd_exc_dt_runs()

  cd ~/research/project/2006-RichyandStarfish-dendIh/dt_runs/

  [t_f1, V_f1] = load_trace('fixed_dt_0.0001.dat');
  [t_f2, V_f2] = load_trace('fixed_dt_0.0005.dat');
  [t_f3, V_f3] = load_trace('fixed_dt_0.001.dat');
  [t_f4, V_f4] = load_trace('fixed_dt_0.005.dat');
  [t_f5, V_f5] = load_trace('fixed_dt_0.01.dat');
  [t_f6, V_f6] = load_trace('fixed_dt_0.05.dat');

  legend_str = {'dt=0.0001', 'dt=0.0005', 'dt=0.001', 'dt=0.005', 'dt=0.01', 'dt=0.05'};
  figure; hold on;

  plot(V_f1, derivative(t_f1, V_f1), 'b-');
  plot(V_f2, derivative(t_f2, V_f2), 'b--');
  plot(V_f3, derivative(t_f3, V_f3), 'r-');
  plot(V_f4, derivative(t_f4, V_f4), 'r--');
  plot(V_f5, derivative(t_f5, V_f5), 'k-');
  plot(V_f6, derivative(t_f6, V_f6), 'k--');

  set(gca,'FontSize',14);
  xlabel('V (mV)');
  ylabel('dV/dt (mV/ms)');
  legend(legend_str);

  figure; hold on;
  plot(t_f1, V_f1, 'b-');
  plot(t_f2, V_f2, 'b--');
  plot(t_f3, V_f3, 'r-');
  plot(t_f4, V_f4, 'r--');
  plot(t_f5, V_f5, 'k-');
  plot(t_f6, V_f6, 'k--');

  set(gca,'FontSize',14);
  xlabel('t (ms)');
  ylabel('V_m (mV)');
  legend(legend_str);
end

function phd_exc_dt_runs_old()

  cd ~/research/project/2006-RichyandStarfish-dendIh/dt_runs/

  [t_f1, V_f1] = load_trace('fixed_dt_0.001.dat');
  [t_f2, V_f2] = load_trace('fixed_dt_0.01.dat');
  [t_f3, V_f3] = load_trace('fixed_dt_0.1.dat');
  [t_f4, V_f4] = load_trace('fixed_dt_0.001_3.dat');

  [t_v1, V_v1] = load_trace('cvode_atol_0.001.dat');
  [t_v2, V_v2] = load_trace('cvode_atol_0.005.dat');

  [t_fc1, V_fc1] = load_trace('fixed_dt_0.001_2.dat');
  [t_fc2, V_fc2] = load_trace('fixed_dt_0.0005.dat');

  legend_str = {'dt=0.001', 'dt=0.01', 'dt=0.1', 'dt=0.001 #2', 'atol=0.001', 'atol=0.005', 'dt=0.001 chen', 'dt=0.0005 chen'};
  figure; hold on;

  plot_VdVdt(t_f1, V_f1, 'b-');
  plot_VdVdt(t_f2, V_f2, 'b--');
  plot_VdVdt(t_f3, V_f3, 'b:');

  plot_VdVdt(t_f4, V_f4, 'k-');

  plot_VdVdt(t_v1, V_v1, 'r-');
  plot_VdVdt(t_v2, V_v2, 'r--');

  plot_VdVdt(t_fc1, V_fc1, 'g-');
  plot_VdVdt(t_fc2, V_fc2, 'g--');

  set(gca,'FontSize',14);
  xlabel('V (mV)');
  ylabel('dV/dt (mV/ms)');
  legend(legend_str);

  figure; hold on;
  plot(t_f1, V_f1, 'b-');
  plot(t_f2, V_f2, 'b--');
  plot(t_f3, V_f3, 'b:');

  plot(t_f4, V_f4, 'k-');

  plot(t_v1, V_v1, 'r-');
  plot(t_v2, V_v2, 'r--');

  plot(t_fc1, V_fc1, 'g-');
  plot(t_fc2, V_fc2, 'g--');
  set(gca,'FontSize',14);
  xlabel('t (ms)');
  ylabel('V_m (mV)');
  legend(legend_str);
end

function [t, V] = load_trace(name)
  A = dlmread(name);
  t = A(:,1);
  V = A(:,2);
end

% h = step size
function [dVdt] = plot_VdVdt(t, V, h, marker)
  dVdt = diff(V(:)) ./ diff(t(:));
  min_length = min(length(V), length(dVdt));
  plot(V(1:length(dVdt)), dVdt, marker);

%{
  dVdt = diff(V)/h;
  plot(V(:,1:length(dVdt)), dVdt, marker);
%}
end

function g = derivative(t, V)

  for i=1:length(V)
    if i == 1
      d = V(2) - V(1);
      dt = t(2) - t(1);
    elseif i == length(V)
      d = V(i) - V(i-1);
      dt = t(i) - t(i-1);
    else
      d = V(i+1) - V(i-1);
      dt = t(i+1) - t(i-1);
    end
    g(i) = d / dt;
  end
end
