
function phd_exc_dt_runs()

  cd ~/research/project/2006-RichyandStarfish-dendIh/dt_runs/

  lspec = {'k-', 'k--', 'b-', 'b--', 'r-', 'r--', 'g-', 'g--', 'c-', 'c--', 'm-', 'm--'};

  [t1, V1] = load_trace('cvode_atol_1e-07.dat');
  [t2, V2] = load_trace('cvode_atol_5e-07.dat');
  [t3, V3] = load_trace('cvode_atol_1e-06.dat');
  [t4, V4] = load_trace('cvode_atol_5e-06.dat');
  [t5, V5] = load_trace('cvode_atol_1e-05.dat');
  [t6, V6] = load_trace('cvode_atol_5e-05.dat');
  [t7, V7] = load_trace('cvode_atol_0.0001.dat');
  [t8, V8] = load_trace('cvode_atol_0.0005.dat');
  [t9, V9] = load_trace('cvode_atol_0.001.dat');
  [t10, V10] = load_trace('cvode_atol_0.005.dat');
  [t11, V11] = load_trace('cvode_atol_0.01.dat');
  [t12, V12] = load_trace('cvode_atol_0.05.dat');

  legend_str = {'atol=1e-07', 'atol=5e-07', 'atol=1e-06', 'atol=5e-06', 'atol=1e-05', 'atol=5e-05', 'atol=0.0001', 'atol=0.0005', 'atol=0.001', 'atol=0.005', 'atol=0.01', 'atol=0.05'};
  figure; hold on;

  plot(V1, derivative(t1, V1), lspec{1});
  plot(V2, derivative(t2, V2), lspec{2});
  plot(V3, derivative(t3, V3), lspec{3});
  plot(V4, derivative(t4, V4), lspec{4});
  plot(V5, derivative(t5, V5), lspec{5});
  plot(V6, derivative(t6, V6), lspec{6});
  plot(V7, derivative(t7, V7), lspec{7});
  plot(V8, derivative(t8, V8), lspec{8});
  plot(V9, derivative(t9, V9), lspec{9});
  plot(V10, derivative(t10, V10), lspec{10});
  plot(V11, derivative(t11, V11), lspec{11});
  plot(V12, derivative(t12, V12), lspec{12});

  set(gca,'FontSize',14);
  xlabel('V (mV)');
  ylabel('dV/dt (mV/ms)');
  legend(legend_str);

  figure; hold on;
  plot(t1, V1, lspec{1});
  plot(t2, V2, lspec{2});
  plot(t3, V3, lspec{3});
  plot(t4, V4, lspec{4});
  plot(t5, V5, lspec{5});
  plot(t6, V6, lspec{6});
  plot(t7, V7, lspec{7});
  plot(t8, V8, lspec{8});
  plot(t9, V9, lspec{9});
  plot(t10, V10, lspec{10});
  plot(t11, V11, lspec{11});
  plot(t12, V12, lspec{12});

  set(gca,'FontSize',14);
  xlabel('t (ms)');
  ylabel('V_m (mV)');
  legend(legend_str);
end

function [t, V] = load_trace(name)
  A = dlmread(name);
  t = A(:,1);
  V = A(:,2);
end

% h = step size
function [dVdt] = plot_VdVdt(t, V, h, marker)
  dVdt = diff(V(:)) ./ diff(t(:));
  min_length = min(length(V), length(dVdt));
  plot(V(1:length(dVdt)), dVdt, marker);

%{
  dVdt = diff(V)/h;
  plot(V(:,1:length(dVdt)), dVdt, marker);
%}
end

function g = derivative(t, V)
  
  for i=1:length(V)
    if i == 1
      d = V(2) - V(1);
      dt = t(2) - t(1);
    elseif i == length(V)
      d = V(i) - V(i-1);
      dt = t(i) - t(i-1);
    else
      d = V(i+1) - V(i-1);
      dt = t(i+1) - t(i-1);
    end
    g(i) = d / dt;
  end
end
