
function [fitting_results, traces, traces_no_spikes] = phd_exc_fitting_bias_load(set, dur, plotit)

% plot results by default
if nargin < 3
    plotit = 1
end

fitting_results = [];
sorted = [];
ranks_old = {'R225', 'R326', 'R961', 'R356', 'S006', 'S037', 'R641', 'S005', 'S026'};
%ranks = {'R225', 'R326', 'R961', 'R356', 'R641'};
ranks = {'R326', 'R961', 'R356', 'R641'};
%parts = {'ia0-5-35'};
parts = {''};
cd ~/data/scinet/scratch/O-LM_runs/phd_exc

traces = {};
traces_no_spikes = {};

for rank = 1:length(ranks)

  % these tie the parts together
  weight_idx = 1;

  for part = 1:length(parts)

    %topdir = sprintf('scen4_bias_%d_%ds_s', set, dur);
    model_dir = sprintf('scen4_bias_%d_s_%s%s', set, ranks{rank}, parts{part});
    %model_dir = sprintf('%s_%03d_%s', topdir, ranks(rank), parts{part});
    %model_dir = sprintf('%s_%s_%s', topdir, ranks{rank}, parts{part});
    disp(sprintf('Entering %s ...\n', model_dir));
    cd(model_dir);
    if ~exist('dev', 'file') 
      disp(sprintf('*** No files in $s; skipping...\n', model_dir));
      pwd;
      cd ..;
      continue;
    end
    cd dev/shm/vsekulic/O-LM_runs/;

    files = dir('*.dat');
    for i = 1:length(files)
      disp(sprintf('*** Processing file %s ...\n', files(i).name));
      [a_t, a_t_nospikes, mean_Vm, std_Vm, spikes, spike_rate] = phd_exc_load_trace(files(i).name);
      traces{i} = a_t;	% first page with orig trace
      traces_no_spikes{i} = a_t_nospikes;	% second page with spike removed trace
      A = sscanf(files(i).name, 'R3_soma_rank%d_h_%g_excw_%g_inhw_%g_tstop_%d_injclamp_%g.dat');
      weight = A(3); % A(4) should be the same, for excw and inhw, respectively
      injclamp = A(6);
      fitting_results(rank, weight_idx, 1) = injclamp;
      fitting_results(rank, weight_idx, 2) = mean_Vm;
      fitting_results(rank, weight_idx, 3) = std_Vm;
      fitting_results(rank, weight_idx, 4) = spike_rate;
      fitting_results(rank, weight_idx, 5) = std(a_t.V);
      weight_idx = weight_idx + 1;
    end
    cd ../../../../../;
  end

  % Make sure we have fitting_results sorted in ascending order of independent variable of interest,
  % e.g., synaptic weight or injclamp. This is a very convoluted method. We extract the 2D subset of
  % each rank's array containing the data, then sort it along the first column of the resulting
  % subset, which is the injclamp (or weight). Then concatenate back onto a sorted array along the 3rd
  % dimension (hence the 3).
  sorted = cat(3, sorted, sortrows(squeeze(fitting_results(rank,:,:))));
end
    
fitting_results = sorted;

if plotit
    phd_exc_fitting_plot(fitting_results);
end

end
