%{
  element:
    1 - mean_Vm
    2 - std_Vm
    3 - spike_rate
    4 - std_Vm_spikes

  E.g., 

    f = phd_exc_fitting_plot_syn(results, weights, ranks, 1, 1:8, 2, 0);
%}
function f = phd_exc_fitting_plot_syn(results, weights, ranks, rank, excw_weight_range, inhw_weight_range, element, rotate_x_degrees, fileloc)

if nargin < 9
    fileloc='';
end

elements = {'Mean Vm', 'Std Vm', 'Spike rate', 'Std Vm-spikes'};

f=figure;

font_size = 8;
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
set(0,'DefaultTextFontSize',font_size);

h=bar3(squeeze(results(rank,excw_weight_range,inhw_weight_range,element)));
for k = 1:length(h)
zdata = h(k).ZData;
h(k).CData = zdata;
h(k).FaceColor = 'interp';
end
%colormap(lbmap(64,'RedBlue'));
colormap(flipud(lbmap(64,'RedBlue')));
colorbar;
set(gca,'XTickLabel',weights(inhw_weight_range),'XTickLabelRotation',-45);
set(gca,'YTickLabel',weights(excw_weight_range),'YTickLabelRotation',45);
xlabel('w_{inh}');
ylabel('w_{exc}');
zlabel(elements{element});
title(sprintf('Rank %d, %s', ranks(rank), elements{element}));
camorbit(rotate_x_degrees, 0);

if fileloc
    excw_weight_str = sprintf('excw_%g-%g', weights(excw_weight_range(1)), weights(excw_weight_range(length(excw_weight_range))));
    inhw_weight_str = sprintf('inhw_%g-%g', weights(inhw_weight_range(1)), weights(inhw_weight_range(length(inhw_weight_range))));
    weight_str = sprintf('%s_%s', excw_weight_str, inhw_weight_str);
    filename = sprintf('rank_%d_%s_%s_rot%d.png', ranks(rank), weight_str, elements{element}, rotate_x_degrees);
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

end
