
function [fitting_results, traces, ranks, skipped_dirs] = phd_exc_fitting_syn_load_blks(topdir, hoc, prefix_strs, weights, plotit, verbose)

if nargin < 6
    verbose = 0;
end
if nargin < 5
    plotit = 0;
end

fitting_results = [];
ranks = [];
skipped_dirs = {};
%weights = [ 2e-06 3e-06 4e-06 5e-06 6e-06 7e-06 8e-06 9e-06 1e-05 2e-05 3e-05 4e-05 5e-05 6e-05 7e-05 8e-05 ];

disp('HERE')
rank_idx = 1;
current_rank = NaN;
for p = 1:length(prefix_strs)
    prefix = prefix_strs{p};

    dirpath = sprintf('%s/%s/%s*', topdir, prefix, prefix);
    dirs = dir(dirpath);
    cd(sprintf('%s/%s', topdir, prefix));
    pwd
    tot_dirs = length(dirs);

    traces = {};

    for i = 1:tot_dirs
        current_model_dir = dirs(i).name;
        % skip . and ..
        if strcmp(current_model_dir, '.') || strcmp(current_model_dir, '..')
            continue;
        end

        disp(current_model_dir);
        cd(current_model_dir);
        disp(sprintf('*** Processing model dir %s', current_model_dir));

        if ~ exist('dev', 'dir')
            disp(sprintf('   *** No models in %s; skipping...', current_model_dir));
            skipped_dirs{length(skipped_dirs)+2} = current_model_dir;
            cd('..');
            continue;
        end
        outfile_dir = './dev/shm/vsekulic/O-LM_runs/';
        cd(outfile_dir);
        pwd
        outfiles = dir('*.dat');
        for j=1:length(outfiles)
            model_name = outfiles(j).name;
            disp(sprintf('    *** Processing file %s', model_name));

            % get params from filename
            if hoc == 's'
                A = sscanf(model_name, 'R3_soma_rank%d_h_%g_Kdrs_%g_excw_%g_inhw_%g_tstop_%d_injclamp_%d.dat');
            elseif hoc == 'sd'
                A = sscanf(model_name, 'R3_somadend_rank%d_h_%g_Kdrs_%g_excw_%g_inhw_%g_tstop_%d_injclamp_%d.dat');
            end
            rank = A(1);
            h = A(2);
            Kdrs = A(3);

            excw = A(4);
            excw_idx = find(weights == excw);
            inhw = A(5);
            inhw_idx = find(weights == inhw);
            disp(sprintf('        excw %g excw_idx %d inhw %g inhw_idx %d', excw, excw_idx, inhw, inhw_idx));

            tstop = A(6);
            injclamp = A(7);

            % Are we in a new rank?
            find_idx = find(ranks == rank);
            if find_idx
                rank_idx = find_idx;
            else
                rank_idx = length(ranks) + 1;
                ranks(rank_idx) = rank;
                disp(sprintf('    *** NEW RANK %d, assigning new rank_idx = %d, length(ranks)==%d\n', rank, rank_idx, length(ranks)));
            end
% DEBUG ONLY
%{
            if rank_idx == 2
                return
            end
%}
                    
            [a_t, a_t_nospikes, mean_Vm, std_Vm, spikes, spike_rate] = phd_exc_load_trace(model_name, plotit, verbose);
% DEBUG ONLY
%{
            mean_Vm = -70;
            std_Vm = 5;
            spike_rate = 2.5;
            a_t.V = [1 2 3 4];
%}

            % Store traces (spikes & no spikes)
    % NOT FOR NOW. TOO MUCH DISK SPACE WHEN SAVING.
    %{
            traces(rank_idx).rank = rank;
            traces(rank_idx).excw(excw_idx).inhw(inhw_idx).a_t = a_t;
            traces(rank_idx).excw(excw_idx).inhw(inhw_idx).a_t_nospikes = a_t_nospikes;
    %}

            % build results array for easy post-processing & plotting
            fitting_results(rank_idx, excw_idx, inhw_idx, 1) = mean_Vm;
            fitting_results(rank_idx, excw_idx, inhw_idx, 2) = std_Vm;
            fitting_results(rank_idx, excw_idx, inhw_idx, 3) = spike_rate;
            fitting_results(rank_idx, excw_idx, inhw_idx, 4) = std(a_t.V);
        end
        pwd
        cd('../../../../../');
        pwd

        disp(sprintf('\n*** COMPLETED %4.2f%% of %s (%d/%d dirs)\n', i*100/tot_dirs, prefix, i, tot_dirs));
    end

    % Get back to topdir so we can go into next prefix dir
    cd('..');
end

% plot them by default
%phd_exc_fitting_plot(fitting_results);

end
