
function [fitting_results, traces, traces_no_spikes] = phd_exc_fitting_syn_load(set, dur)

fitting_results = [];
ranks_old = [225, 326, 961, 356, 006, 037, 641, 005, 026];
ranks = {'R225', 'R326', 'R961', 'R356', 'S006', 'S037', 'R641', 'S005', 'S026'};
parts = {'29', '18'};
cd ~/data/scinet/O-LM_runs/phd_exc

traces = {};
traces_no_spikes = {};

for rank = 1:length(ranks)

  % these tie the parts together
  weight_idx = 1;

  for part = 1:length(parts)

    topdir = sprintf('scen4_%d_%ds_s', set, dur);
    %model_dir = sprintf('%s_%03d_%s', topdir, ranks(rank), parts{part});
    model_dir = sprintf('%s_%s_%s', topdir, ranks{rank}, parts{part});
    disp(sprintf('Entering %s ...\n', model_dir));
    cd(model_dir);
    if ~exist('dev', 'file') 
      disp(sprintf('*** No files in $s; skipping...\n', model_dir));
      pwd;
      cd ..;
      continue;
    end
    cd dev/shm/vsekulic/O-LM_runs/;

    files = dir('*.dat');
    for i = 1:length(files)
      disp(sprintf('*** Processing file %s ...\n', files(i).name));
      [a_t, a_t_nospikes, mean_Vm, std_Vm, spikes, spike_rate] = phd_exc_load_trace(files(i).name);
      traces{i} = a_t;	% first page with orig trace
      traces_no_spikes{i} = a_t_nospikes;	% second page with spike removed trace
      A = sscanf(files(i).name, 'R3_soma_rank%d_h_%g_excw_%g_inhw_%g_tstop_%d_injclamp_%d.dat');
      weight = A(3); % A(4) should be the same, for excw and inhw, respectively
      fitting_results(rank, weight_idx, 1) = weight;
      fitting_results(rank, weight_idx, 2) = mean_Vm;
      fitting_results(rank, weight_idx, 3) = std_Vm;
      fitting_results(rank, weight_idx, 4) = spike_rate;
      fitting_results(rank, weight_idx, 5) = std(a_t.data);
      weight_idx = weight_idx + 1;
    end
    cd ../../../../../;
  end
end

% plot them by default
phd_exc_fitting_plot(fitting_results);

end
