function [cell1_ranks, cell2_ranks] = phd_exc_load_cells_to_ranks(models)
    phd_exc_load_cell;
    cell1_ranks = [];
    cell2_ranks = [];
    for i=1:length(models)
        rank = models(i).rank;
        if any(cell1 == rank) 
            cell1_ranks = [cell1_ranks i];
        elseif any(cell2 == rank)
            cell2_ranks = [cell2_ranks i];
        else
            disp(sprintf('*** ERROR: cannot find cell# of rank %d', rank));
        end 
    end 
end
