function [hD0_ranks, hD1_ranks] = phd_exc_load_models_to_ranks(models)
    phd_exc_load_ranks;
    hD0_ranks = [];
    hD1_ranks = [];
    for i=1:length(models)
        rank = models(i).rank;
        if any(ranks_hD0 == rank) 
            hD0_ranks = [hD0_ranks i];
        elseif any(ranks_hD1 == rank)
            hD1_ranks = [hD1_ranks i];
        else
            disp(sprintf('*** ERROR: cannot find hD of rank %d', rank));
        end 
    end 
end
