
function [models] = phd_exc_load_sets()

dir_mod = 'scen4_mod_1_30s_s_';

mo = {'0.2', '0.4', '0.6', '0.8'};
mf = {'0.5', '1', '2', '3', '5', '8', '20', '30'};

%%%%%%%%
% RICHY
%%%%%%%%

models(1).rank = '225';
models(1).cell = 1;
models(1).hD = 1;
models(1).nomod.path = 'scen4_3_60s_s_R225_18/dev/shm/vsekulic/O-LM_runs/R3_soma_rank225_h_1e-05_excw_7e-05_inhw_7e-05_tstop_60000_injclamp_0.dat';

models(2).rank = '326';
models(2).cell = 1;
models(2).hD = 0;
models(2).nomod.path = 'scen4_3_60s_s_R326_18/dev/shm/vsekulic/O-LM_runs/R3_soma_rank326_h_5e-05_excw_3e-05_inhw_3e-05_tstop_60000_injclamp_0.dat';

models(3).rank = '356';
models(3).cell = 1;
models(3).hD = 1;
models(3).nomod.path = 'scen4_3_60s_s_R356_18/dev/shm/vsekulic/O-LM_runs/R3_soma_rank356_h_1e-05_excw_4e-05_inhw_4e-05_tstop_60000_injclamp_0.dat';

models(4).rank = '641';
models(4).cell = 1;
models(4).hD = 1;
models(4).nomod.path = 'scen4_3_60s_s_R641_18/dev/shm/vsekulic/O-LM_runs/R3_soma_rank641_h_5e-06_excw_3e-05_inhw_3e-05_tstop_60000_injclamp_0.dat';

models(5).rank = '961';
models(5).cell = 1;
models(5).hD = 0;
models(5).nomod.path = 'scen4_3_60s_s_R961_18/dev/shm/vsekulic/O-LM_runs/R3_soma_rank961_h_1e-05_excw_2e-05_inhw_2e-05_tstop_60000_injclamp_0.dat';

% Need 1 more hD1, 1 more hD0

%%%%%%%%%%
% STARFISH
%%%%%%%%%%

%{
models(6).rank = '006';
models(6).cell = 2;
models(6).hD = 1;

models(7).rank = '037';
models(7).cell = 2;
models(7).hD = 1;

models(8).rank = '005';
models(8).cell = 2;
models(8).hD = 1;
%}

% Need 1 more hD1, 3 more hD0

% topdir
cd /home/vsekulic/data/scinet/scratch/O-LM_runs/phd_exc

%
% Get PSDs for all models.
%
for i=1:length(models)
    disp(sprintf('*** Processing rank %s', models(i).rank));

    % Calculate psd for nomod
    disp(sprintf('    Loading nomod PSD at path %s ...', models(i).nomod.path));
    [a_t, a_prof, pxx, f, V] = phd_exc_psd(models(i).nomod.path);
    models(i).nomod.psd = struct('a_t', a_t, 'a_prof', a_prof, 'pxx', pxx, 'f', f, 'V', V);

    % Get all files for this model first before calculating psds for mods
    disp(sprintf('    Loading mod PSDs:'));
    dirs = dir(sprintf('%s%s*', dir_mod, models(i).rank));
    models(i).mod.paths = {};
    for d=1:length(dirs)
        current_dir = dirs(d).name;
        disp(sprintf('        %s:', current_dir));
        model_parent_dir = sprintf('%s%s', current_dir, '/dev/shm/vsekulic/O-LM_runs');
        files = dir(sprintf('%s/*.dat', model_parent_dir));
        for f_idx=1:length(files)
            current_file = files(f_idx).name;
            disp(sprintf('            file %s', current_file));

            % Get mo and mf parameters from filename.
            A = sscanf(current_file, 'R3_soma_rank%d_h_%g_excw_%g_inhw_%g_tstop_%g_modfreq_%g_modulation_%g_injclamp_%g.dat');
            % rank = A(1);
            % h = A(2);
            % excw = A(3);
            % inhw = A(4);
            % tstop = A(5);
            modfreq = A(6);
            modulation = A(7);
            % injclamp = A(8);
            
            % Calculate psd for nomod
            [a_t, a_prof, pxx, f, V] = phd_exc_psd(sprintf('%s/%s', model_parent_dir, current_file));
            % each dir is a separate modfreq, so use that as an index into mf.
            models(i).mod.mo(d).psd(f_idx) = struct('a_t', a_t, 'a_prof', a_prof, 'pxx', pxx, 'f', f, 'V', V, 'path', current_file, 'mf', modfreq, 'mo', modulation);
            models(i).mod.mo(d).mo = modulation;
            disp(sprintf('                 -> models(%d).mod.mo(%d).psd(%d) struct formed with mo %g mf %g', i, d, f_idx, modulation, modfreq));
        end
    end
end

end
