%{

    ranks is an array of ranks to process; ignore everything else. Facilitates splitting the work into 
    multiple MATLAB instances to save memory.

%}
function [models] = phd_exc_load_sets(topdir, prefix_str, desired_mo, desired_ranks)

RRATE_PHASES = 57;

if nargin < 4
    desired_ranks = [];
end
if nargin < 3
    desired_mo = 0;
end

%mo = {'0.2', '0.4', '0.6', '0.8'};
%mf = {'0.5', '1', '2', '3', '5', '8', '20', '30'};
phd_exc_load_mod % to get mo and mf

%models(1).rank = '225';
%models(1).cell = 1;
%models(1).hD = 1;
%models(1).nomod.path = 'scen4_3_60s_s_R225_18/dev/shm/vsekulic/O-LM_runs/R3_soma_rank225_h_1e-05_excw_7e-05_inhw_7e-05_tstop_60000_injclamp_0.dat';

rank_idx = 1;
ranks = [];
hoc = '';
model_nomod_format = '';
model_mod_format = '';

%
% Get PSDs for all models.
%
cd(topdir);
for p=1:length(prefix_str)
prefix = prefix_str{p};
cd(prefix);
disp(sprintf('*** PROCESSING PREFIX %s', prefix));
pwd

dirpath = sprintf('%s*', prefix);
dirs = dir(dirpath);
tot_dirs = length(dirs);
for i=1:tot_dirs
    current_model_dir = dirs(i).name;
    % skip . and ..
    if strcmp(current_model_dir, '.') || strcmp(current_model_dir, '..')
        continue;
    end

    disp(current_model_dir);

    % Find type
    type = '';
    if ~isempty(strfind(current_model_dir, 'nomod')) % then 'nomod' is part of dir name
        type = 'nomod';
    else
        type = 'mod';
    end

    cd(current_model_dir);
    disp(sprintf('*** Processing model dir %s', current_model_dir));
    %cd(sprintf('%s/dev/shm/vsekulic/O-LM_runs', current_model_dir));

    % Only if mod, cd to subdir tree at dev/shm/vsekulic/O-LM_runs; if type is 'nomod', then the
    % one and only datafile will be in the current dir, so don't go anywhere (this gets skipped)
    if strcmp(type, 'mod')
        if ~exist('dev', 'file')
            disp(sprintf('    *** NO dev FILE; SKIPPING....\n'));
            cd('..');
            continue;
        end
        outfile_dir = './dev/shm/vsekulic/O-LM_runs/';
        cd(outfile_dir);
    end

    outfiles = dir('*.dat');
    pwd
    for j=1:length(outfiles)
        model_name = outfiles(j).name;

        % Find if we're in Scenario 4 or 5 and fix the format accordingly.
        if strcmp(hoc, '')
            if strfind(model_name, 'somadend')
                model_nomod_format = 'R3_somadend_rank%d_h_%g_Kdrs_%g_excw_%g_inhw_%g_tstop_%d_injclamp_%d.dat';
                model_mod_format = 'R3_somadend_rank%d_h_%g_Kdrs_%g_excw_%g_inhw_%g_tstop_%d_modfreq_%g_modulation_%g_injclamp_%d.dat';
                hoc = 'sd';
            else
                model_nomod_format = 'R3_soma_rank%d_h_%g_Kdrs_%g_excw_%g_inhw_%g_tstop_%d_injclamp_%d.dat';
                model_mod_format = 'R3_soma_rank%d_h_%g_Kdrs_%g_excw_%g_inhw_%g_tstop_%d_modfreq_%g_modulation_%g_injclamp_%d.dat';
                hoc = 's';
            end
        end

        disp(sprintf('    *** Processing outfile %s for hoc type %s', model_name, hoc));

        % Parse params from filename
        if strcmp(type, 'nomod')
            A = sscanf(model_name, model_nomod_format);
            injclamp = A(7);
        else
            A = sscanf(model_name, model_mod_format);
            modfreq = A(7);
            modulation = A(8);
            if desired_mo > 0 && modulation ~= desired_mo
                disp(sprintf('        -> modulation %g does not match desired_mo %g; skipping...', modulation, desired_mo));
                continue
            end
            injclamp = A(9);
        end
        rank = A(1);
        h = A(2);
        Kdrs = A(3);
        excw = A(4);
        inhw = A(5);
        tstop = A(6);

        % Do we want to process this rank?
        if ~isempty(desired_ranks) && ~any(desired_ranks == rank)
            disp(sprintf('    *** NOT DESIRED RANK %d, skipping...\n', rank));
            continue;
        end

        % Are we in a new rank?
        find_idx = find(ranks == rank);
        if find_idx
            rank_idx = find_idx;
        else
            rank_idx = length(ranks) + 1;
            ranks(rank_idx) = rank;
            disp(sprintf('    *** NEW RANK %d, assigning new rank_idx = %d, length(ranks)==%d\n', rank, rank_idx, length(ranks)));
        end
        models(rank_idx).rank = rank;

        [a_t, a_prof, pxx, f, V] = phd_exc_psd(model_name);
        models(rank_idx).params.h = h;
        models(rank_idx).params.Kdrs = Kdrs;
        models(rank_idx).params.excw = excw;
        models(rank_idx).params.inhw = inhw;
        models(rank_idx).params.tstop = tstop;
        models(rank_idx).params.injclamp = injclamp;
        models(rank_idx).params.path = model_name;

        if strcmp(type, 'nomod')
            disp(sprintf('        nomod file', model_name));
            % Don't keep trace for now, memory requirements too high.
            %models(rank_idx).nomod.psd = struct('a_t', a_t, 'a_prof', a_prof, 'pxx', pxx, 'f', f, 'V', V, 'path', model_name);
            models(rank_idx).nomod.psd = struct('a_prof', a_prof, 'pxx', pxx, 'f', f, 'path', model_name);

        else % type == 'mod'

            %[a_t, a_prof, pxx, f, V] = phd_exc_psd(model_name);
            rel = phd_exc_reliability(a_t, a_prof, RRATE_PHASES, modfreq);
            % fill in later
            mo_idx = find(mo == modulation);
            mf_idx = find(mf == modfreq);
            % Don't keep trace for now, memory requirements too high.
            %models(rank_idx).mod.mo(mo_idx).mf(mf_idx).psd = struct('a_t', a_t, 'a_prof', a_prof, 'pxx', pxx, 'f', f, 'V', V, 'path', model_name, 'mf', modfreq, 'mo', modulation);
            models(rank_idx).mod.mo(mo_idx).mf(mf_idx).psd = struct('a_prof', a_prof, 'pxx', pxx, 'f', f, 'path', model_name, 'mf', modfreq, 'mo', modulation, 'rel', rel);
            disp(sprintf('        -> models(%d).mod.mo(%d).mf(%d).psd struct formed with mo %g mf %g rr %g er %g extras %d rr_win %g er_win %g extras_win %d Rnum %g Rnum_win %g amean %g amean_win %g', rank_idx, mo_idx, mf_idx, modulation, modfreq, rel.rrate.rr, rel.rrate.er, rel.rrate.extras, rel.rrate.rr_win, rel.rrate.er_win, rel.rrate.extras_win, rel.psth.Rnum, rel.psth.Rnum_win, rel.amean.amean, rel.amean.amean_win));
        end
    end

    % Go back to topdir/prefix, which will require a different command depending on type
    if strcmp(type, 'mod')
        cd('../../../../../');
    else
        cd('..');
    end

    disp(sprintf('\n*** COMPLETED %4.2f%% (%d/%d dirs)\n', i*100/tot_dirs, i, tot_dirs));
% DEBUG
%{
    if rank_idx == 2
        break;
    end
%}
end

cd('..'); % go back to topdir
end

for i=1:length(models)
    for mo_idx=1:length(models(i).mod.mo)
        for j=length(models(i).mod.mo(mo_idx).mf)+1:length(mf)
            models(i).mod.mo(mo_idx).mf(j).psd = [];
        end
    end
end

end

