
function [a_t, a_t_nospikes, mean_Vm, std_Vm, spikes, spike_rate] = phd_exc_load_trace(model_path, plotit, verbose)
  if nargin < 3
    verbose = 0;
  end
  if nargin < 2
    plotit = 0;
  end
  A = dlmread(model_path);
  t = A(:,1);
  V = A(:,2);
  a_t = trace(V, 1e-4, 1e-3, model_path, struct('init_Vm_method',6,'spike_finder',3,'threshold',-20,'init_threshold',-20));
  thres = -20;
  [timeidx, peakval, n] = findspikes_old(V, t, thres, plotit);

  % Only remove spikes if there are spikes to remove
  if n > 0
    [t_nospikes, V_nospikes] = removeSpikes(t, V, timeidx, thres);
    tm = t_nospikes;
    Vm = V_nospikes;
  else
    tm = t;
    Vm = V;
  end

  mean_Vm = mean(Vm);
  std_Vm = std(Vm);
  spike_rate = n/(t(length(t))*1e-3);
  spikes = n;

  if verbose
    disp(sprintf('mean Vm: %g, std Vm: %g, spikes: %d, spike rate: %g\n', mean(Vm), std(Vm), spikes, spike_rate));
  end

  a_t = struct('t', t, 'V', V);
  a_t_nospikes = struct('t', tm, 'V', Vm);
end
