
function [a_t, a_t_nospikes, mean_Vm, std_Vm, spikes, spike_rate] = phd_exc_load_trace(model_path)
  A = dlmread(model_path);
  V = A(:,2);
  a_t = trace(V, 1e-4, 1e-3, model_path, struct('init_Vm_method',6,'spike_finder',3,'threshold',-20,'init_threshold',-20));
  a_prof = getProfileAllSpikes(a_t);

  % Only remove spikes if there are spikes to remove
  if a_prof.results.Spikes > 0
    a_t_nospikes = removeSpikes(a_t);
    Vm = a_t_nospikes.data;
  else
    Vm = a_t.data;
    a_t_nospikes = [];
  end

  mean_Vm = mean(Vm);
  std_Vm = std(Vm);
  spike_rate = a_prof.results.SpikeRate;
  spikes = a_prof.results.Spikes;
  disp(sprintf('mean Vm: %g, std Vm: %g, spikes: %d, spike rate: %g\n', mean(Vm), std(Vm), a_prof.results.Spikes, a_prof.results.SpikeRate));
end
