
%topdir = '~/data/scinet/scratch/O-LM_runs/phd_exc';
topdir = '~/bigdata/scinet/scratch/O-LM_runs/phd_exc';
%prefix_str = {'scen5_mod_5' 'scen5_mod_6'};
%prefix_str = {'scen5_mod_8', 'scen5_mod_10'};
prefix_str = {'scen5_mod_13'};
name = 'scen5_mod';
desired_mo = 0.4;
fileloc = '~/Dropbox/research/project/img/pratio_nat'
MAT_fileprefix = sprintf('scen5_mod_blh_mo_%g', desired_mo);
MAT_dir = '~/research/project/MAT_files';

phd_exc_load_ranks;
props = struct();

%diary(sprintf('%s/%s.out', MAT_dir, MAT_fileprefix)); tic;
[models_hD0] = phd_exc_load_sets(topdir, prefix_str, desired_mo, ranks_hD0);
%pr_nat_hD0 = phd_exc_pratio_nat(models_hD0, desired_mo, sprintf('scen5 Ih blocked hD0 mo %g', desired_mo), props, fileloc);

[models_hD1] = phd_exc_load_sets(topdir, prefix_str, desired_mo, ranks_hD1);
%pr_nat_hD1 = phd_exc_pratio_nat(models_hD1, desired_mo, sprintf('scen5 Ih blocked hD1 mo %g', desired_mo), props, fileloc);


models = [models_hD0 models_hD1];
[hD0_ranks, hD1_ranks ] = phd_exc_load_models_to_ranks(models);
disp(sprintf('SAVING...'));

% THIS ONE
save(sprintf('%s/%s.mat', MAT_dir, MAT_fileprefix),'-v7.3');
%toc; diary off;
