% mf - modulation frequency values in vector
function f = phd_exc_plot_pr_nat_models(pr_nat_models, desired_modulation, title_str, fileloc)
    phd_exc_load_mod; % to get mf
    f=figure;
    if size(pr_nat_models, 1) > 1 % more than one row, so have more than one model
        boxplot(pr_nat_models);
    else % just for that one model
        bar(pr_nat_models);
    end
    set(gca,'XTickLabel',[0 mf]);
    title(sprintf('Natural power ratios - %s', title_str));
    ylim([0:1]);
    ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));

    if fileloc
        filename = sprintf('pratio_nat_%g_%s.png', desired_modulation, title_str);
        disp(sprintf('PRINTING to file %s', filename));
        print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
    end

end
