
function f = phd_exc_plot_pratio_8Hz(pr_nat, titlestr, scen, desired_mo)
    f=figure;
    num_models = size(pr_nat,1);
    num_modfreqs = size(pr_nat,2);
    X=cat(2,ones(1,num_models),ones(1,num_models)+1,ones(1,num_models)+2,ones(1,num_models)+3);
    hold on;
    scatter(X, reshape(pr_nat, [1 num_models*num_modfreqs]))
    boxplot(pr_nat)
    set(gca,'FontSize',16);
    set(gca,'XTickLabel',{'No mod', 'No mod, no Ih', '8Hz mod', '8Hz mod, no Ih'},'FontSize',14);
    set(gca,'XTickLabelRotation',-45);
    ylabel('Ratio of 8Hz power to 0Hz power');
    %title(sprintf('Scenario %d, mo %g, power ratio at 8Hz %s', scen, desired_mo, titlestr));
    title(titlestr);
end
