%{

  Inputs:
    models - struct array returned by phd_exc_load_sets.m

  Outputs: 
    Will plot the power ratio plots for the frequency ranges that exist in the models struct.

  Example:
    phd_exc_pratio(models, 8);

%}
function pr_models = phd_exc_pratio_all(models, desired_modulation, rotate_x_degrees, title_str, plotit)
%disp(sprintf('desired_freq %g desired_modulation %g', desired_freq, desired_modulation));

% plot by default!
if nargin < 5
    plotit = 0;
end
phd_exc_load_mod % to get mo and mf
mf_orig=mf;
mf=mf(2:length(mf));

pr_models = [];

%%%%%%%%%%%%%%%%%%%%%%%%
% SCENARIO 4 - soma only
%%%%%%%%%%%%%%%%%%%%%%%%

for i=1:length(models)

    % Calculate power ratio at desired frequency for no modulation traces
    psd_nomod = models(i).nomod.psd;
    for k=1:length(mf)
        df = mf(k);
        idx_dHz = find(psd_nomod.f == df);
        idx_0Hz = find(psd_nomod.f == 0);
        pr_p = psd_nomod.pxx(idx_dHz) / psd_nomod.pxx(idx_0Hz);
        if isnan(pr_p)
            pr_p = 0;
        end
        %models(i).nomod.psd.pr_p = pr_p;
        pr_models(1, k, i) = pr_p;
    end

    % Find the mo first
    mo_idx = find(mo == desired_modulation);
%{
    mo_idx = 0;
    for k=1:length(models(i).mod.mo)
        if models(i).mod.mo(k).mo == desired_modulation
            mo_idx = k;
        end
    end
%}

    if isempty(models(i).mod)
        disp(sprintf('*** models(i).mod IS EMPTY; SKIPPING.....'));
        continue;
    end

    % Now for the power ratio of the modulated frequencies, at the desired modulation amount
    for j=1:length(mf)
        mf_idx=find(mf_orig==mf(j));
        psd_mod = models(i).mod.mo(mo_idx).mf(mf_idx).psd
        if isempty(psd_mod) % to deal with cancelled jobs...
%            pr_models(j+1, :, i) = NaN; %???does this work???
            disp(sprintf('models(%d) rank %d mf %d has missing psd, REMOVED', i, models(i).rank, j));
            continue;
        else
            for k=1:length(mf)
                df = mf(k);
                idx_dHz = find(psd_mod.f == df);
                idx_0Hz = find(psd_mod.f == 0);
                pr_p = psd_mod.pxx(idx_dHz) / psd_mod.pxx(idx_0Hz);

                % Some models have missing PSDs, so exclude them entirely from subsequent statistics.
                if pr_p == 0
                    disp(sprintf('models(%d) rank %d mf %d has 0 power ratio but PSD NOT empty, why? REMOVED anyway', i, models(i).rank, j));
%                    pr_p = NaN;
                end
                if psd_mod.a_prof.n < 6
                    disp(sprintf('models(%d) rank %d mf %d has <= 5 spikes, REMOVED', i, models(i).rank, j));
%                    pr_p = NaN;
                    pr_p = 0;
                end
                pr_models(j+1, k, i) = pr_p;
            end
        end
        %models(i).mod.mo(mo_idx).mf(j).pr_p = pr_p;
    end
end

% Sanitize pr_models via two steps:
% 1. Set all NaN values to zeros;
% 2. Set all pr_ratio values close to 1 to zero
%pr_models(isnan(pr_models)) = 0;
%{
for i=1:size(pr_models,1)
    for j=1:size(pr_models,2)
        if pr_models(i,j) >= 1-1e-09
            disp(sprintf('    i %d j %d removed as pr_ratio close to 1', i,j));
            pr_models(i,j) = NaN;
        end
    end
end
%}
            
if plotit
    figure;
    % surf() *very stupidly* treats x as y and vice versa (in Z argument to function)
    % so need to flip axes - simply do matrix transpose
    surf(median(pr_models,3)');
    camorbit(rotate_x_degrees,0);
    %set(gca,'XTickLabel',[0 mf]);

    xl={'nm','0.5','1','2','3','4','5','8','9','10','12','15','16','20','25','30'};
    yl={'0.5','1','2','3','4','5','8','9','10','12','15','16','20','25','30'};
    set(gca,'XTick',1:length(xl))
    set(gca,'XTickLabel',xl);
    set(gca,'YTick',1:length(yl))
    set(gca,'YTickLabel',yl);
    title(sprintf('Power ratios - %s', title_str));
    %ylabel(sprintf('Ratio of %gHz power to zero frequency power', df));
end

end
