%{

  Inputs:
    models - struct array returned by phd_exc_load_sets.m

  Outputs: 
    Will plot the natural power ratio plots for the frequency ranges that exist in the models struct.

  Example:
    phd_exc_pratio(models, 'title');

E.g., 

phd_exc_pratio_nat(models_hD0_mod_1, 0.2, 'hD0, Ih, mo=0.2')
phd_exc_pratio_nat(models_hD0_mod_2, 0.2, 'hD0, no Ih, mo=0.2')
phd_exc_pratio_nat(models_hD0_mod_1, 0.4, 'hD0, Ih, mo=0.4')
phd_exc_pratio_nat(models_hD0_mod_2, 0.4, 'hD0, no Ih, mo=0.4')
phd_exc_pratio_nat(models_hD0_mod_1, 0.6, 'hD0, Ih, mo=0.6')
phd_exc_pratio_nat(models_hD0_mod_2, 0.6, 'hD0, no Ih, mo=0.6')
phd_exc_pratio_nat(models_hD1_mod_1, 0.2, 'hD1, Ih, mo=0.2')
phd_exc_pratio_nat(models_hD1_mod_2, 0.2, 'hD1, no Ih, mo=0.2')
phd_exc_pratio_nat(models_hD1_mod_1, 0.4, 'hD1, Ih, mo=0.4')
phd_exc_pratio_nat(models_hD1_mod_2, 0.4, 'hD1, no Ih, mo=0.4')

%}
function pr_nat_models = phd_exc_pratio_nat(models, desired_modulation, title_str, props, fileloc)

if nargin < 5
    fileloc='';
end
if nargin < 4
    props = struct();
end

if isfield(props,'anal_type')
    anal_type = props.anal_type;
else
    anal_type = '';
end
if isfield(props,'pratio')
    pratio = props.pratio;
else
    pratio = 1;
end
if isfield(props,'fileformat')
    fileformat = props.fileformat;    
else
    fileformat = '-dpng';
end

pr_nat_models = [];
phd_exc_load_mod % to get mo and mf
%% UNCOMMENT TO GET RID OF 0.1; 0.5
%mf=mf(3:length(mf));
mo_idx = find(mo == desired_modulation);

for rank=1:length(models)
 
%{
    pr_models = phd_exc_pratio(models, 8, desired_modulation, '', 0); % throaway just to get nomod
    pr_nat_models(rank, 1) = pr_models(rank, 1);
%}

    % Now for the power ratio of the modulated frequencies
    for j=1:length(mf)
        pr_models = [];
        if strcmp(anal_type, 'q')
            pr_models = phd_exc_Qval(models, mf(j), desired_modulation, '', 0);
            disp(sprintf('QVAL!!!!\n'));
        elseif strcmp(anal_type, 'r')
            pr_models = phd_exc_rrate(models, mf(j), desired_modulation, '', 0);
            disp(sprintf('Response rate!!!!\n'));
        elseif strcmp(anal_type, 'cAMP')
            pr_models = phd_exc_pratio_cAMP(models, mf(j), desired_modulation, '', props, 0);
            disp(sprintf('cAMP!\n'));
            pr_nat_models(rank, j) = pr_models(rank, j);
        else
            pr_models = phd_exc_pratio(models, mf(j), desired_modulation, '', props, 0);
            pr_nat_models(rank, j) = pr_models(rank, j+1);
        end
%% UNCOMMENT TO GET RID OF 0.1
%        pr_nat_models(rank, j) = pr_models(rank, j+3);
%        pr_nat_models(rank, j) = pr_models(rank, j+3);
    end
end
            
X = phd_exc_load_plotting(length(models), size(pr_nat_models,2));
size(pr_nat_models,2)
f=figure;
hold on;
if length(models) > 1
    scatter(X, reshape(pr_nat_models, [1 size(pr_nat_models,1)*size(pr_nat_models,2)]),15,'k');
    boxplot(pr_nat_models);
else
    bar(pr_nat_models);
end
set(gca,'FontSize',16);
set(gca,'XTickLabel',mf);
set(gca,'XTickLabelRotation',-45);
title(sprintf('%s', title_str),'FontSize',16);
if pratio
    ylim([0:1]);
end
%ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));
if pratio
    ylabel('Power ratio');
else
    ylabel('Power');
end
xlabel('Modulation frequencies (Hz)');

if pratio
    PREFIX_STR='pratio';
else
    PREFIX_STR='pr';
end

if fileloc
disp(sprintf('PRINTING'))
    filename = sprintf('%s_nat_%g_%s.png', PREFIX_STR, desired_modulation, title_str);
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), fileformat);
end

end
