% "nat" because we are calculating power ratio of the frequency of the modulated synapses
% viz., the "natural" frequency. To test spiking preference at particular modulation freqs.
%

%%%%%%%%%%%%%%%%%%%%%%%%
% SCENARIO 4 - soma only
%%%%%%%%%%%%%%%%%%%%%%%%

% No modulation
%{
idx_8Hz = find(f_s0 == 8);
idx_0Hz = find(f_s0 == 0);
prs8mod0 = pxx_s0(idx_8Hz) / pxx_s0(idx_0Hz);

idx_8Hz = find(f_sh0 == 8);
idx_0Hz = find(f_sh0 == 0);
prs8mod0nh = pxx_sh0(idx_8Hz) / pxx_sh0(idx_0Hz);
%}

% 2Hz modulation
idx_2Hz = find(f_s2_06 == 2);
idx_0Hz = find(f_s2_06 == 0);
prs2mod2 = pxx_s2_06(idx_2Hz) / pxx_s2_06(idx_0Hz);

idx_2Hz = find(f_sh2_06 == 2);
idx_0Hz = find(f_sh2_06 == 0);
prs2mod2nh = pxx_sh2_06(idx_2Hz) / pxx_sh2_06(idx_0Hz);

% 8Hz modulation
idx_8Hz = find(f_s8_06 == 8);
idx_0Hz = find(f_s8_06 == 0);
prs8mod8 = pxx_s8_06(idx_8Hz) / pxx_s8_06(idx_0Hz);

idx_8Hz = find(f_sh8_06 == 8);
idx_0Hz = find(f_sh8_06 == 0);
prs8mod8nh = pxx_sh8_06(idx_8Hz) / pxx_sh8_06(idx_0Hz);

% 20Hz modulation
idx_20Hz = find(f_s20_06 == 20);
idx_0Hz = find(f_s20_06 == 0);
prs20mod20 = pxx_s20_06(idx_20Hz) / pxx_s20_06(idx_0Hz);

idx_20Hz = find(f_sh20_06 == 20);
idx_0Hz = find(f_sh20_06 == 0);
prs20mod20nh = pxx_sh20_06(idx_20Hz) / pxx_sh20_06(idx_0Hz);

% 30Hz modulation
idx_30Hz = find(f_s30_06 == 30);
idx_0Hz = find(f_s30_06 == 0);
prs30mod30 = pxx_s30_06(idx_30Hz) / pxx_s30_06(idx_0Hz);

idx_30Hz = find(f_sh30_06 == 30);
idx_0Hz = find(f_sh30_06 == 0);
prs30mod30nh = pxx_sh30_06(idx_30Hz) / pxx_sh30_06(idx_0Hz);

figure;
bar([prs2mod2, prs2mod2nh, prs8mod8, prs8mod8nh, prs20mod20, prs20mod20nh, prs30mod30, prs30mod30nh]);
set(gca,'XTickLabel',{'2Hz mod','2Hz mod+ZD','8Hz mod','8Hz mod+ZD','20Hz mod','20Hz mod+ZD','30Hz mod','30Hz mod+ZD'});
title('Power ratios for somatic inputs');
ylim([0:1]);
ylabel('Ratio of modulated frequency power to zero frequency power');


%%%%%%%%%%%%%%%%%%%%%%%
% SCENARIO 5 - somadend
%%%%%%%%%%%%%%%%%%%%%%%

% No modulation
%{
idx_8Hz = find(f_sd0 == 8);
idx_0Hz = find(f_sd0 == 0);
prsd8mod0 = pxx_sd0(idx_8Hz) / pxx_sd0(idx_0Hz);

idx_8Hz = find(f_sdh0 == 8);
idx_0Hz = find(f_sdh0 == 0);
prsd8mod0nh = pxx_sdh0(idx_8Hz) / pxx_sdh0(idx_0Hz);
%}

% 2Hz modulation
idx_2Hz = find(f_sd2_06 == 2);
idx_0Hz = find(f_sd2_06 == 0);
prsd2mod2 = pxx_sd2_06(idx_2Hz) / pxx_sd2_06(idx_0Hz);

idx_2Hz = find(f_sdh2_06 == 2);
idx_0Hz = find(f_sdh2_06 == 0);
prsd2mod2nh = pxx_sdh2_06(idx_2Hz) / pxx_sdh2_06(idx_0Hz);

% 8Hz modulation
idx_8Hz = find(f_sd8_06 == 8);
idx_0Hz = find(f_sd8_06 == 0);
prsd8mod8 = pxx_sd8_06(idx_8Hz) / pxx_sd8_06(idx_0Hz);

idx_8Hz = find(f_sdh8_06 == 8);
idx_0Hz = find(f_sdh8_06 == 0);
prsd8mod8nh = pxx_sdh8_06(idx_8Hz) / pxx_sdh8_06(idx_0Hz);

% 20Hz modulation
idx_20Hz = find(f_sd20_06 == 20);
idx_0Hz = find(f_sd20_06 == 0);
prsd20mod20 = pxx_sd20_06(idx_20Hz) / pxx_sd20_06(idx_0Hz);

idx_20Hz = find(f_sdh20_06 == 20);
idx_0Hz = find(f_sdh20_06 == 0);
prsd20mod20nh = pxx_sdh20_06(idx_20Hz) / pxx_sdh20_06(idx_0Hz);

% 30Hz modulation
idx_30Hz = find(f_sd30_06 == 30);
idx_0Hz = find(f_sd30_06 == 0);
prsd30mod30 = pxx_sd30_06(idx_30Hz) / pxx_sd30_06(idx_0Hz);

idx_30Hz = find(f_sdh30_06 == 30);
idx_0Hz = find(f_sdh30_06 == 0);
prsd30mod30nh = pxx_sdh30_06(idx_30Hz) / pxx_sdh30_06(idx_0Hz);

figure;
bar([prsd2mod2, prsd2mod2nh, prsd8mod8, prsd8mod8nh, prsd20mod20, prsd20mod20nh, prsd30mod30, prsd30mod30nh]);
set(gca,'XTickLabel',{'2Hz mod','2Hz mod+ZD','8Hz mod','8Hz mod+ZD','20Hz mod','20Hz mod+ZD','30Hz mod','30Hz mod+ZD'});
title('Power ratios for somatodendritic inputs');
ylim([0:1]);
ylabel('Ratio of modulated frequency power to zero frequency power');
