%{

  Inputs:
    models - struct array returned by phd_exc_load_sets.m

  Outputs: 
    Will plot the natural power ratio plots for the frequency ranges that exist in the models struct.

  Example:
    phd_exc_pratio(models, 'title');

E.g., 

phd_exc_pratio_nat(models_hD0_mod_1, 0.2, 'hD0, Ih, mo=0.2')
phd_exc_pratio_nat(models_hD0_mod_2, 0.2, 'hD0, no Ih, mo=0.2')
phd_exc_pratio_nat(models_hD0_mod_1, 0.4, 'hD0, Ih, mo=0.4')
phd_exc_pratio_nat(models_hD0_mod_2, 0.4, 'hD0, no Ih, mo=0.4')
phd_exc_pratio_nat(models_hD0_mod_1, 0.6, 'hD0, Ih, mo=0.6')
phd_exc_pratio_nat(models_hD0_mod_2, 0.6, 'hD0, no Ih, mo=0.6')
phd_exc_pratio_nat(models_hD1_mod_1, 0.2, 'hD1, Ih, mo=0.2')
phd_exc_pratio_nat(models_hD1_mod_2, 0.2, 'hD1, no Ih, mo=0.2')
phd_exc_pratio_nat(models_hD1_mod_1, 0.4, 'hD1, Ih, mo=0.4')
phd_exc_pratio_nat(models_hD1_mod_2, 0.4, 'hD1, no Ih, mo=0.4')

%}
function pr_models = phd_exc_pratio_nat_nat(models, desired_modulation, desired_modfreq, title_str, fileloc)

if nargin < 5
    fileloc='';
end

pr_nat_models = [];
phd_exc_load_mod % to get mo and mf
mo_idx = find(mo == desired_modulation);

pr_models = phd_exc_pratio(models, desired_modfreq, desired_modulation, '', 0);
            
X = phd_exc_load_plotting(length(models));
f=figure;
hold on;
if length(models) > 1
    scatter(X, reshape(pr_models, [1 size(pr_models,1)*size(pr_models,2)]),15,'k');
    boxplot(pr_models);
else
    bar(pr_models);
end
set(gca,'FontSize',16);
set(gca,'XTickLabel',[0 mf]);
set(gca,'XTickLabelRotation',-45);
title(sprintf('%s', title_str),'FontSize',16);
ylim([0:1]);
ylabel(sprintf('Ratio of %g frequency power to 0Hz power', desired_modfreq));
xlabel('Modulation frequencies (Hz)');

if fileloc
    filename = sprintf('pratio_nat_nat_%g_%g_%s.png', desired_modulation, desired_modfreq, title_str);
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

end
