%{

  Inputs:
    models - struct array returned by phd_exc_load_sets.m
    desired_power - a number corresponding to the desired frequency for the power ratio calculation

  Outputs: 
    Will plot the power ratio plots for the frequency ranges that exist in the models struct.

  Example:
    phd_exc_pratio(models, 8);

%}
function pr_models = phd_exc_pratio(models, desired_power, desired_modulation, title_str, plotit)

% plot by default!
if nargin < 4
    plotit = 1;
end

pr_models = [];
p = desired_power;

idx_nomod = 1;
idx_05 = 2;
idx_1 = 3;
idx_2 = 4;
idx_3 = 5;
idx_5 = 6;
idx_8 = 7;
idx_20 = 8;
idx_30 = 9;

NUM_MOD = 8;

%%%%%%%%%%%%%%%%%%%%%%%%
% SCENARIO 4 - soma only
%%%%%%%%%%%%%%%%%%%%%%%%


for i=1:length(models)

    % Calculate power ratio at desired frequency for no modulation traces
    psd_nomod = models(i).nomod.psd;
    idx_pHz = find(psd_nomod.f == p);
    idx_0Hz = find(psd_nomod.f == 0);
    pr_p = psd_nomod.pxx(idx_pHz) / psd_nomod.pxx(idx_0Hz);
    models(i).nomod.psd.pr_p = pr_p;
    pr_models(i, idx_nomod) = pr_p;

    % Find the mo first
    mo_idx = 0;
    for k=1:length(models(i).mod.mo)
        if models(i).mod.mo(k).mo == desired_modulation
            mo_idx = k;
        end
    end

    % Now for the power ratio of the modulated frequencies, at the desired modulation amount
    for j=1:NUM_MOD
        psd_mod = models(i).mod.mo(mo_idx).psd(j);
        idx_pHz = find(psd_mod.f == p);
        idx_0Hz = find(psd_mod.f == 0);
        pr_p = psd_mod.pxx(idx_pHz) / psd_mod.pxx(idx_0Hz);
        models(i).mod.mo(mo_idx).psd(j).pr_p = pr_p;

        % Group power ratio for all modulation frequencies of all models together
        switch psd_mod.mf
            case 0.5
                pr_models(i, idx_05) = pr_p;
            case 1
                pr_models(i, idx_1) = pr_p;
            case 2
                pr_models(i, idx_2) = pr_p;
            case 3
                pr_models(i, idx_3) = pr_p;
            case 5
                pr_models(i, idx_5) = pr_p;
            case 8
                pr_models(i, idx_8) = pr_p;
            case 20
                pr_models(i, idx_20) = pr_p;
            case 30
                pr_models(i, idx_30) = pr_p; 
        end
    end
end
            
if plotit
    figure;
    if length(models) > 1
        boxplot(pr_models);
    else
        bar(pr_models);
    end
    set(gca,'XTickLabel',{'No mod','0.5Hz','1Hz','2Hz','3Hz','5Hz','8Hz','20Hz','30Hz'});
    title(sprintf('Power ratios at %gHz power - %s', p, title_str));
    ylim([0:1]);
    ylabel(sprintf('Ratio of %gHz power to zero frequency power', p));
end

end
