
function [a_t, a_prof, pxx, f, V] = phd_exc_psd(model_path, plotit, verbose)

  if nargin < 3
    verbose = 0;
  end
  if nargin < 2
    plotit = 0;
  end
  fs = 1e3;
  A = dlmread(model_path);
  t = A(:,1);
  V = A(:,2);
  a_t = trace(V, 1e-4, 1e-3, model_path, struct('init_Vm_method',6,'spike_finder',3,'threshold',-20,'init_threshold',-20,'t',t));

  thres = -30;
  %plotit = 0;
  [timeidx, peakval, n] = findspikes_old(V, t, thres, plotit);
  % t(timeidx) now gives spike times.

  % Create a new type of "profile object" so that upstream code can still
  % call this function and still "expect" a_prof
  a_prof = struct('timeidx', timeidx, 'peakval', peakval, 'n', n, 'thres', thres);
  if verbose
    disp(sprintf('Detected %d spikes for %s\n', n, model_path));
  end

  x=zeros(1,floor(t(length(t)))); % so we can use arbitrary length traces
  x(floor(t(timeidx)))=1;
  
  if plotit == 1
    figure; hold on;
    plot(t, V, 'b');
    plot(x, 'r');
    legend({'V_m', 'Spike peaks'});
  end

  if verbose
    disp(sprintf('Generating PSD for %s\n', model_path));
  end
  [pxx,f]=pwelch(x,[],[],[0:0.1:100],fs);
  %[pxx,f]=pwelch(x,[],[],[],fs);

  if plotit == 1
    figure;
    loglog(f,pxx);
  end
end
