%{

Arguments:
a_t - trace object as returned by phd_exc_psd()
a_prof - "profile" object as returned by phd_exc_psd()
num_phases - how many phases to consider
f - frequency of modulation of interest
plotit - (optional) plot window under consideration

%}
%function [rr, er, extras, rr_win, er_win, extras_win] = phd_exc_rrate(a_t, a_prof, num_phases, freq, verbose)
function [rel_struct] = phd_exc_reliability(a_t, a_prof, num_phases, freq, verbose)
    if nargin < 5
        verbose = 0;
    end

    if verbose
        disp(sprintf('We have %d phases and %d freq', num_phases, freq));
    end

    t = a_t.props.t;
    x=t(a_prof.timeidx)';
%    yt=[1e3/freq/2:1e3/freq:20000];
    yt=[1e3/freq/2:1e3/freq:floor(t(length(t)))];
    period = 1e3/freq;

%    cum_spikes = cum_spikes_plot(a_t, a_prof, yt, num_phases, period);
    cum_spikes = cum_spikes_plot(a_t, a_prof, yt, period);

    xwin=rel_window(x,freq,num_phases);
    ytwin=rel_window(yt,freq,num_phases);
    spike_struct = struct('x',x,'yt',yt,'xwin',xwin,'ytwin',ytwin);
    
    % Get response rate (REPLACE THIS WITH ROTATION # SOON)
    [rr, er, extras] = rrate(x,yt,verbose);
    [rr_win, er_win, extras_win] = rrate(xwin,ytwin,verbose);
    rrate_struct = struct('rr',rr,'er',er,'extras',extras,'rr_win',rr_win,'er_win',er_win,'extras_win',extras_win);

    % Get PSTH data
    psth_struct = calc_psth(x,yt,freq);
    psth_struct_win = calc_psth(xwin,ytwin,freq);
    %f = fit(bintimes', psth', 'gauss1');

    % Vector strength
    [VS, R] = vector_strength(psth_struct.diffs, 1e3/freq);
    [VS_win, R_win] = vector_strength(psth_struct_win.diffs, 1e3/freq);
    psth_struct.VS = VS;
    psth_struct.R = R;
    psth_struct.VS_win = VS_win;
    psth_struct.R_win = R_win;

    % Added rotation number instead of replacing rrate
    Rnum = rotnumber(x,yt,verbose);
    Rnum_win = rotnumber(xwin,ytwin,verbose);
    psth_struct.Rnum = Rnum;
    psth_struct.Rnum_win = Rnum_win;

    % Angular mean
    amean = angmean(psth_struct.diffs, period);
    amean_win = angmean(psth_struct_win.diffs, period);
    amean_struct = struct('amean',amean,'amean_win',amean_win);
    
    rel_struct = struct('rrate',rrate_struct,'psth',psth_struct,'spike',spike_struct,'amean',amean_struct);
end
