%{

Plots rotation numbers for models across desired modulation frequencies.

If 'win' is set to 1, then only a window of fixed cycles for each frequency is considered.

Will plot resulting response and erotnor rate plots.

%}
function [rotn_models] = phd_exc_rotn_plots(models, desired_modulation, desired_modfreqs, title_str, win, fileloc)

if nargin < 5
    fileloc='';
end

rotn_models = [];
phd_exc_load_mod; % to get mo and mf
mo_idx = find(mo == desired_modulation);
mf_indices = find(ismember(mf, desired_modfreqs));

for rank=1:length(models)
 
%    for j=1:length(mf_indices)
    for j=1:length(mf)
%        mf_idx = mf_indices(j);
disp(sprintf('rank %d j %d', rank, j));
models(rank).mod
        psd = models(rank).mod.mo(mo_idx).mf(j).psd;
        if isempty(psd)
            rotn_models(rank,j) = NaN;
            continue;
        end
        if ~win
            rotn_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.psth.Rnum;
        else
            rotn_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.psth.Rnum_win;
        end
    end
end

Nfreqs = length(desired_modfreqs);
%X = phd_exc_load_plotting(length(models), size(rotn_models,2));
X = phd_exc_load_plotting(length(models), Nfreqs);
f=figure;
hold on;
if length(models) > 1
%    scatter(X, reshape(rotn_models, [1 size(rotn_models,1)*size(rotn_models,2)]),15,'k');
    scatter(X, reshape(rotn_models(:,mf_indices), [1 size(rotn_models,1)*Nfreqs]),15,'k');
    boxplot(rotn_models(:,mf_indices));
else
    bar(rotn_models);
end
%plot([1 size(rotn_models,2)], [1 1], 'k--'); % Horizontal line at Rnum=1
plot([1 Nfreqs], [1 1], 'k--'); % Horizontal line at Rnum=1
set(gca,'FontSize',16);
set(gca,'XTickLabel',desired_modfreqs);
set(gca,'XTickLabelRotation',-45);
title(sprintf('%s', title_str),'FontSize',16);
%ylim([0:1]);
%ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));
ylabel('Rotation number');
xlabel('Modulation frequencies (Hz)');

if fileloc
    if ~win
        filename = sprintf('rotn_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('rotn_win_%g_%s.png', desired_modulation, title_str);
    end
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

end
