%{

Plots response and error rates for models across desired modulation frequencies.

If 'win' is set to 1, then only a window of fixed cycles for each frequency is considered.

Will plot resulting response and error rate plots.

%}
function [rr_models, er_models] = phd_exc_rrate_plots(models, desired_modulation, title_str, win, fileloc)

if nargin < 5
    fileloc='';
end

rr_models = [];
er_models = [];
phd_exc_load_mod; % to get mo and mf
mo_idx = find(mo == desired_modulation);

for rank=1:length(models)
 
    for j=1:length(mf)
        if ~win
            rr_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.rrate.rr;
            er_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.rrate.er;
        else
            rr_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.rrate.rr_win;
            er_models(rank,j) = models(rank).mod.mo(mo_idx).mf(j).psd.rel.rrate.er_win;
        end
    end
end
            
X = phd_exc_load_plotting(length(models), size(rr_models,2));
Y = phd_exc_load_plotting(length(models), size(er_models,2));
f=figure;
hold on;
if length(models) > 1
    scatter(X, reshape(rr_models, [1 size(rr_models,1)*size(rr_models,2)]),15,'k');
    boxplot(rr_models);
else
    bar(rr_models);
end
set(gca,'FontSize',16);
set(gca,'XTickLabel',mf);
set(gca,'XTickLabelRotation',-45);
title(sprintf('%s', title_str),'FontSize',16);
ylim([0:1]);
%ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));
ylabel('Response rate');
xlabel('Modulation frequencies (Hz)');

if fileloc
    if ~win
        filename = sprintf('rr_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('rr_win_%g_%s.png', desired_modulation, title_str);
    end
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

% Have to pause otherwise below plots don't get annotated properly. 
pause(1);
f=figure;
hold on;
if length(models) > 1
    scatter(Y, reshape(er_models, [1 size(er_models,1)*size(er_models,2)]),15,'k');
    boxplot(er_models);
else
    bar(er_models);
end
set(gca,'FontSize',16);
set(gca,'XTickLabel',mf);
set(gca,'XTickLabelRotation',-45);
title(sprintf('%s', title_str),'FontSize',16);
ylim([0:1]);
%ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));
ylabel('Error rate');
xlabel('Modulation frequencies (Hz)');

if fileloc
    if ~win
        filename = sprintf('er_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('er_win_%g_%s.png', desired_modulation, title_str);
    end
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

end
