
function [results, pvals] = phd_exc_stats(first, second, desired_mfs, desired_pval)
    if nargin < 4
        DESIRED_PVAL = 0.01;
    else
        DESIRED_PVAL = desired_pval;
    end
    disp(sprintf('Desired p value is < %g', DESIRED_PVAL));

    phd_exc_load_mod;
    if nargin < 3
        desired_mfs = mf;
    end

    pvals = [];
    results = {};
    pval_str = '';
    for j=1:length(desired_mfs)
        idx=find(mf==desired_mfs(j));
        disp(sprintf('Looking at j %d, idx %d, mf %g', j, idx, mf(idx)));

        if (sum(~isnan(first(:,idx))) < 4 || sum(~isnan(second(:,idx))) < 4)
            results{idx} = sprintf('%g Hz, not enough datapoints, skipped', mf(idx));
            pvals(idx) = NaN;
            continue;
        end
        not_norm = lillietest(first(:,idx));
        lillie_str = '';
        if not_norm
            lillie_str = 'first';
        end
        not_norm_blh = lillietest(second(:,idx));
        if not_norm_blh
            if ~isempty(lillie_str)
                lillie_str = strcat(lillie_str, ', second');
            else
                lillie_str = 'second';
            end
        end
        if ~isempty(lillie_str)
            lillie_str = strcat(lillie_str, ' not normal');
        else
            lillie_str = 'both dist normal';
        end

        if not_norm || not_norm_blh
            G=[ones(1,length(first(:,idx))) ones(1,length(second(:,idx)))+1];
            %[p,tbl,stats] = kruskalwallis([pr_nat(:,idx)' pr_nat_blh(:,idx)'], G, 'off')
            C=[first(:,idx)' second(:,idx)'];
%{
            size(G)
            size(C)
disp(sprintf('%g Hz',desired_mfs(j)));
C
G
%}
            [p,tbl,stats] = kruskalwallis([first(:,idx)' second(:,idx)'], G, 'off')

            if p < DESIRED_PVAL
                pval_str = '***';
            else
                pval_str = '';
            end                
            results{idx} = sprintf('%g Hz, p = %g KW (%s) %s', mf(idx), p, lillie_str, pval_str);
            pvals(idx) = p;
        else        
            [h,p,ci,stats] = ttest2(first(:,idx),second(:,idx))
            if p < DESIRED_PVAL
                pval_str = '***';
            else
                pval_str = '';
            end                
            results{idx} = sprintf('%g Hz, p = %g tt2 (%s) %s', mf(idx), p, lillie_str, pval_str);
            pvals(idx) = p;
        end
    end

    for j=1:length(results)
        disp(results{j})
    end
end
