
function [results, p] = phd_exc_stats_paired(first, second, desired_pval)
    if nargin < 3
        DESIRED_PVAL = 0.05;
    else
        DESIRED_PVAL = desired_pval;
    end
    disp(sprintf('Desired p value is < %g', DESIRED_PVAL));

    not_norm = adtest(first);
    ad_str = '';
    if not_norm
        ad_str = 'first';
    end
    not_norm_second = adtest(second);
    if not_norm_second
        if ~isempty(ad_str)
            ad_str = strcat(ad_str, ', second');
        else
            ad_str = 'second';
        end
    end
    if ~isempty(ad_str)
        ad_str = strcat(ad_str, ' not normal');
    else
        ad_str = 'both dist normal';
    end

    if not_norm || not_norm_second
        [p, h, stats] = ranksum(first, second);
        test_str = 'Wilcoxon';
    else
        [h, p, ci, stats] = ttest(first, second);
        test_str = 'Paired t-test';
    end

    if p < DESIRED_PVAL
        pval_str = '*';
    else
        pval_str = 'n.s.';
    end
    results = sprintf('p = %g %s (%s) %s', p, test_str, ad_str, pval_str);

    disp(results);
end
