
function [pvals,rm_anova_tbl] = phd_exc_stats_rm(first, second, desired_mfs, desired_pval)
    if nargin < 4
        DESIRED_PVAL = 0.05;
    else
        DESIRED_PVAL = desired_pval;
    end
    disp(sprintf('Desired p value is < %g', DESIRED_PVAL));

    phd_exc_load_mod;
    if nargin < 3
        desired_mfs = mf;
    end

    pvals = [];
    results = {};
    pval_str = '';

    rm_data = [first, second];
%    rm_mf = {'0.1Hz';'0.5Hz';'1Hz';'2Hz';'3Hz';'4Hz';'5Hz';'8Hz';'9Hz';'10Hz';'12Hz';'15Hz';'16Hz';'20Hz';'25Hz';'30Hz'};
%    rm_mf = {0.1;0.5;1;2;3;4;5;8;9;10;12;15;16;20;25;30};
    rm_mf = {'01';'02';'03';'04';'05';'06';'07';'08';'09';'10';'11';'12';'13';'14';'15';'16'};
    rm_HS = {'S';'S';'S';'S';'S';'S';'S';'S';'S';'S';'S';'S';'S';'S';'S';'S'};
    rm_HSD = {'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD';'SD'};
    rm_factornames = {'MF','HD'};
    rm_within = table({rm_mf{:} rm_mf{:}}', {rm_HS{:} rm_HSD{:}}', 'VariableNames', rm_factornames);
    rm_varnames = {'Y1','Y2','Y3','Y4','Y5','Y6','Y7','Y8','Y9','Y10','Y11','Y12','Y13','Y14','Y15','Y16','Y17','Y18','Y19','Y20','Y21','Y22','Y23','Y24','Y25','Y26','Y27','Y28','Y29','Y30','Y31','Y32'};
    rm_t = array2table(rm_data,'VariableNames',rm_varnames);
    rm = fitrm(rm_t,'Y1-Y32~1','WithinDesign',rm_within)
    rm_anova_tbl = ranova(rm, 'WithinModel','MF*HD')
    c=multcompare(rm,'HD','By','MF')
    mauchly(rm)
    epsilon(rm)
    T=table2struct(c)
    new_T=T(strcmp({T(:).HD_1},'S'));
    pvals = [new_T(:).pValue];
end
