
function results = phd_exc_stats_rr(rr, rr_blh, desired_mfs)

    phd_exc_load_mod;
    if nargin < 3
        desired_mfs = mf;
    end

    results = {};
    for j=1:length(desired_mfs)
        idx=find(mf==desired_mfs(j));
        disp(sprintf('Looking at j %d, idx %d, mf %g', j, idx, mf(idx)));

        if (sum(~isnan(rr(:,idx))) < 4 || sum(~isnan(rr_blh(:,idx))) < 4)
            results{idx} = sprintf('%g Hz, not enough datapoints, skipped', mf(idx));
            continue;
        end
        not_norm = lillietest(rr(:,idx));
        lillie_str = '';
        if not_norm
            lillie_str = 'Ih';
        end
        not_norm_blh = lillietest(rr_blh(:,idx));
        if not_norm_blh
            if ~isempty(lillie_str)
                lillie_str = strcat(lillie_str, ', blh');
            else
                lillie_str = 'blh';
            end
        end
        if ~isempty(lillie_str)
            lillie_str = strcat(lillie_str, ' not normal');
        else
            lillie_str = 'both dist normal';
        end

        if not_norm || not_norm_blh
            G=[ones(1,length(rr(:,idx))) ones(1,length(rr_blh(:,idx)))+1];
            %[p,tbl,stats] = kruskalwallis([pr_nat(:,idx)' pr_nat_blh(:,idx)'], G, 'off')
            C=[rr(:,idx)' rr_blh(:,idx)'];
%{
            size(G)
            size(C)
disp(sprintf('%g Hz',desired_mfs(j)));
C
G
%}
            [p,tbl,stats] = kruskalwallis([rr(:,idx)' rr_blh(:,idx)'], G, 'off')
            results{idx} = sprintf('%g Hz, p = %g KW (%s)', mf(idx), p, lillie_str);
        else        
            [h,p,ci,stats] = ttest2(rr(:,idx),rr_blh(:,idx))
            results{idx} = sprintf('%g Hz, p = %g tt2 (%s)', mf(idx), p, lillie_str);
        end
    end

    for j=1:length(results)
        disp(results{j})
    end
end
