
function [results, pval] = phd_exc_stats_subth(first, second, desired_pval)
    if nargin < 3
        DESIRED_PVAL = 0.01;
    else
        DESIRED_PVAL = desired_pval;
    end
    disp(sprintf('Desired p value is < %g', DESIRED_PVAL));

    pval = [];
    results = {};
    pval_str = '';

    if (sum(~isnan(first(:))) < 4 || sum(~isnan(second(:))) < 4)
        results = sprintf('ERROR: not enough datapoints');
        pval = NaN;
        return;
    end
    not_norm = lillietest(first(:));
    lillie_str = '';
    if not_norm
        lillie_str = 'first';
    end
    not_norm_blh = lillietest(second(:));
    if not_norm_blh
        if ~isempty(lillie_str)
            lillie_str = strcat(lillie_str, ', second');
        else
            lillie_str = 'second';
        end
    end
    if ~isempty(lillie_str)
        lillie_str = strcat(lillie_str, ' not normal');
    else
        lillie_str = 'both dist normal';
    end

    if not_norm || not_norm_blh
        G=[ones(1,length(first(:))) ones(1,length(second(:)))+1];
        %[p,tbl,stats] = kruskalwallis([pr_nat(:,idx)' pr_nat_blh(:,idx)'], G, 'off')
        C=[first(:)' second(:)'];
%{
            size(G)
            size(C)
disp(sprintf('%g Hz',desired_mfs(j)));
C
G
%}
        [p,tbl,stats] = kruskalwallis([first(:)' second(:)'], G, 'off')

        if p < DESIRED_PVAL
            pval_str = '***';
        else
            pval_str = '';
        end                
        results = sprintf('p = %g KW (%s) %s', p, lillie_str, pval_str);
        pval = p;
    else        
        [h,p,ci,stats] = ttest2(first(:),second(:))
        if p < DESIRED_PVAL
            pval_str = '***';
        else
            pval_str = '';
        end                
        results = sprintf('p = %g tt2 (%s) %s', p, lillie_str, pval_str);
        pval = p;
    end

    disp(results)
end
